﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace NT2chView
{
    /// <summary>
    /// NTFontSelectDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class NTFontSelectDialog : Window
    {
        public String FontName
        {
            get;
            set;
        }

        public NTFontSelectDialog()
        {
            InitializeComponent();
        }

         private void NTFontSelectDialog_Loaded(object sender, RoutedEventArgs e)
        {
            edtFontName.Text = FontName;


            int idx = 0;
            int selIdx = -1;
            foreach (FontFamily fontFamily in Fonts.SystemFontFamilies)
            {
                string source = fontFamily.Source;
                lstFonts.Items.Add(source);
                if (source.Equals(FontName))
                    selIdx = idx;
                idx++;
            }

            if (selIdx >= 0)
            {
                
                lstFonts.SelectedIndex = selIdx;
                lstFonts.ScrollIntoView(lstFonts.SelectedItem);
            }

        }
       
        private void lstFonts_selectionChanged(object sender, SelectionChangedEventArgs e)
        {
            ListBox lb = sender as ListBox;
            if (lb != null)
            {
                ListBoxItem lbi =lb.SelectedItem as ListBoxItem;
                if (lbi != null)
                {
                    edtFontName.Text = lbi.Content.ToString();
                }
                else
                {
                    string fontName = lb.SelectedItem as string;
                    if (fontName != null)
                    {
                        edtFontName.Text = fontName;
                    }

                }

            }

        }

        private void btnOK_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = true;
            FontName = edtFontName.Text;
            this.Close();
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
            FontName = string.Empty;
            this.Close();

        }

    }
}
