﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    sealed class NTTextFormat
    {
        public static string[] HTTP_SCHME_ARR = { "TTP://", "TTPS://", "ttp://", "ttps://"};

        static char [] NUMERIC_2ch = {'0','1','2','3','4','5','6','7','8','9','０','１','２','３','４','５','６','７','８','９'};


        public static string convertLineBreakToHtmlTag(string source)
        {
            string[] lines = NTTextUtiles.splitLine(source);
            StringBuilder sb = new StringBuilder();
            foreach (string line in lines)
            {
                sb.Append(line.Trim()).Append("<br>");
            }
            return sb.ToString();
        }

        public static string removeTag(string source)
        {
            source = source.Replace("<br>", "\n");
            source = source.Replace("<BR>", "\n");
            StringBuilder sb = new StringBuilder();
            int len = source.Length;
            bool inTag = false;
            for (int i = 0; i < len; i++)
            {
                char c = source[i];
                switch (c)
                {
                    case '<':
                        inTag = true;
                        break;
                    case '>':
                        if (!inTag)
                            sb.Append(c);
                        inTag = false;
                        break;
                    default:
                        if (!inTag)
                            sb.Append(c);
                        break;
                }
            }

            return sb.ToString();
        }

        public static int parse2chNumA(string inText, int start)
        {		
		    bool flag1 = false;
		    bool flag2 = false;

            int ltCnt = 0;
		
		    int charCnt = 0, numCharCnt = 0;
		
		    for(int i = start; i < inText.Length; i++){
			    char c= inText[i];
			    if('>' == c || '＞' == c)
                {
				    if(0 < numCharCnt){
					    break;
                    }else if(ltCnt > 1){//&lt;は2回まで
                        return -1;
				    }
                    ltCnt++;
				    charCnt++;
			    }
                else if (ltCnt == 0)
                {
                    return -1;
                }
                else if ('-' == c)
                {
                    if (!flag1)
                    {
                        charCnt--;
                        break;
                    }
                    else if (flag2)
                    {
                        break;
                    }
                    charCnt++;
                    flag1 = false;
                    flag2 = true;
                    continue;

                }
                else if (',' == c)
                {
                    if (!flag1)
                    {
                        charCnt--;
                        break;
                    }
                    charCnt++;
                    flag1 = false;
                    continue;
                }
                else
                {
                    flag1 = false;
                    for (int j = 0; j < NUMERIC_2ch.Length; j++)
                    {
                        if (NUMERIC_2ch[j] == c)
                        {
                            flag1 = true;
                            charCnt++;
                            numCharCnt++;
                            break;
                        }

                    }
                    if (!flag1)
                    {
                        break;
                    }
                }
		    }	
		    return (0 < numCharCnt) ? charCnt : -1;
	    }

        public static int parse2chNum(string inText, int start)
        {
		
		    bool flag1 = false;
		    bool flag2 = false;
		
		    int charCnt = 0, numCharCnt = 0;
		
		    for(int i = start; i < inText.Length; i++){
			    char c= inText[i];
			    if('-' == (c)){
				    if(0 == charCnt){
					    return 0;
				    }else if(!flag1){
					    charCnt--;
					    break;
				    }else if(flag2){
					    break;
				    }
				    charCnt++;
				    flag1 = false;
				    flag2 = true;
				    continue;
			
			    }else if(',' == c){
				    if(0 == charCnt){
					    return 0;
				    }else if(!flag1){
					    charCnt--;
					    break;
				    }
				    charCnt++;
				    flag1 = false;
				    continue;
			    }else if('>' == c){
				    if(0 < numCharCnt){
					    break;
				    }else if(i != start){
					    return 0;
				    }
				    charCnt++;
			    }else if('＞' == c){
					if(0 < numCharCnt){
					    break;
				    }else if(i != start){
					    return 0;
				    }
				    charCnt++;
			    }else{
				    flag1 = false;
				    for(int j = 0; j < NUMERIC_2ch.Length; j++){
					    if(NUMERIC_2ch[j] == c){
						    flag1 = true;
						    charCnt++;
						    numCharCnt++;
						    break;
					    }
					
				    }
				    if(0 == charCnt){
					    return 0;
				    }else if(!flag1){
					    break;
				    }
			    }
		    }
		
		    return (0 < numCharCnt) ? charCnt : 0;
	    }

        public static List<int> parseReferenceNumber(string source)
        {
            List<int> list = new List<int>();


            bool fGT = false; //Greater than symbol
            //bool fLT = false; //Less than symbol
            bool fNum = false;// previous char is numeric.
            StringBuilder buf = new StringBuilder();
            int previousNum = -1;
            bool resetPrevChar = false;

            char prevChar = '\0';

            for (int i = 0; i < source.Length; i++)
            {
                char c = source[i];
                switch (c)
                {
                    case '-':
                        if (fNum && previousNum == -1)
                        {
                            string s = buf.ToString();
                            buf.Remove(0, buf.Length);
                            try
                            {
                                previousNum = int.Parse(s);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                                previousNum = -1;
                            }
                            resetPrevChar = false;
                        }
                        else
                        {
                            resetPrevChar = true;
                            previousNum = -1;
                        }
                        fNum = false;
                        fGT = false;
                        break;
                    case ',':
                        if (fNum)
                        {
                            string s = buf.ToString();
                            buf.Remove(0, buf.Length);
                            int n = 0;// null;
                            try
                            {
                                n = int.Parse(s);
                                if (-1 == previousNum)
                                {
                                    list.Add(n);
                                }
                                else
                                {
                                    int len = n - previousNum;
                                    if (len > 11) { len = -1; }//ignore more than 10 successive references
                                    for (int j = 0; j <= len; j++)
                                    {
                                        list.Add((previousNum + j));
                                    }
                                    previousNum = -1;
                                }
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            fNum = false;
                            resetPrevChar = false;
                        }
                        else
                        {
                            resetPrevChar = true;
                        }
                        fGT = false;
                        break;
                    case '>':
                    case '＞':
                        fGT = true;
                        fNum = false;
                        break;
                    default:
                        if (fGT || fNum || (!resetPrevChar && (prevChar == ',' || prevChar == '-')))
                        {
                            int j = 0;
                            for (; j < NUMERIC_2ch.Length; j++)
                            {
                                if (NUMERIC_2ch[j] == c)
                                {
                                    break;
                                }
                            }
                            if (NUMERIC_2ch.Length > j)
                            {
                                fNum = true;
                                if (9 < j)
                                {
                                    c = NUMERIC_2ch[j - 10];
                                }
                                buf.Append(c);
                            }
                            else
                            {
                                if (fNum)
                                {
                                    String s = buf.ToString();
                                    buf.Remove(0, buf.Length);
                                    int n = 0;// null;
                                    try
                                    {
                                        n = int.Parse(s);
                                        if (-1 == previousNum)
                                        {
                                            list.Add(n);
                                        }
                                        else
                                        {
                                            int len = n - previousNum;
                                            if (len > 11) { len = -1; }//ignore more than 10 successive references
                                            for (int k = 0; k <= len; k++)
                                            {
                                                list.Add((previousNum + k));
                                            }
                                            previousNum = -1;
                                        }
                                    }
                                    catch (Exception e) {
                                        NTDebug.l(e.Message);
                                    }
                                }
                                fNum = false;
                            }
                        }
                        fGT = false;
                        break;
                }// end of switch
                prevChar = c;
            }//end of for
            if (fNum)
            {
                string s = buf.ToString();
                //buf.Remove(0, buf.Length);
                int n;
                if (int.TryParse(s, out n))
                {
                    if (previousNum < 0)
                    {
                        list.Add(n);
                    }
                    else
                    {
                        int len = n - previousNum;
                        if (len > 11) { len = -1; }//ignore more than 10 successive references
                        for (int k = 0; k <= len; k++)
                        {
                            list.Add((previousNum + k));
                        }
                    }
                }
            }
            if (list.Count == 0)
            {
                return null;
            }
            return list;
        }

        public static string formatReferenceNumbers(int[] valList)
        {
            if (null == valList) { return null; }
            if (0 >= valList.Length) { return null; }

            StringBuilder buf = new StringBuilder();
            buf.Append("<<");

            bool flagFirst = true;

            int prevVal = 0;
            int i = 0;
            for (; i < valList.Length - 1; i++)
            {
                int val1 = valList[i];
                int val2 = valList[i + 1];
                if (val1 == val2 - 1)
                {
                    if (0 == prevVal)
                    {
                        prevVal = val1;
                    }
                }
                else
                {
                    if (!flagFirst)
                    {
                        buf.Append(',');
                    }
                    else
                    {
                        flagFirst = false;
                    }
                    if (0 != prevVal)
                    {
                        buf.Append(prevVal.ToString());
                        buf.Append('-');
                        buf.Append(val1.ToString());
                        prevVal = 0;
                    }
                    else
                    {
                        buf.Append(val1.ToString());
                    }
                }
            }

            if (!flagFirst)
            {
                buf.Append(',');
            }
            if (0 != prevVal)
            {
                buf.Append(prevVal.ToString());
                buf.Append('-');
                buf.Append(valList[i].ToString());
            }
            else
            {
                buf.Append(valList[i].ToString());
            }

            return buf.ToString();
        }
	
    }
}
