﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Text;
using NT2chView.NtNet;

namespace NT2chView
{
    sealed class NTTextUtiles
    {
        public static int[] EMPTY_INT_ARRAY = new int[0];
        public static char[] COMMA_VALUE = { ',' };
        public static char[] LINE_SEPARATOR = { '\n' };
        public static char[] YEN_VALUE = { '\\' };
        public static char[] EQUAL_VALUE = { '=' };

        static char[] HEX_CHAR_ARR = {
            '0', '1', '2', '3', '4', '5', '6','7', '8','9',
            'A', 'B','C','D','E','F'};



        public static char[] byteToHexChar(char n)
        {
            int upper = ((n & 0xf0) >> 4);
            int lower = n & 0x0f;
            char[] c = new char[2];
            c[0] = HEX_CHAR_ARR[upper];
            c[1] = HEX_CHAR_ARR[lower];
            return c;

        }
        public static string[] splitLine(string source)
        {
            return source.Split(LINE_SEPARATOR);
        }

        public static string concatLines(string[] lines)
        {
            bool init = false;
            StringBuilder sb = new StringBuilder();
            foreach (string line in lines)
            {
                if (line.Length == 0)
                    continue;
                if(line.Length == 1 && line[0] == 0x0d)
                    continue;

                if (!init)
                {
                    init = true;
                }
                else
                {
                    sb.Append(LINE_SEPARATOR);
                }
                int len = line.Length;
                if (line[len - 1] == 0x0d)
                {
                    sb.Append(line.Substring(0, len-1));
                }
                else
                {
                    sb.Append(line);
                }
            }
            return sb.ToString();
        }
        

        public static string constructCommaSepLineFromInt(int[] numbers)
        {
            if (numbers == null)
                return string.Empty;

            StringBuilder sb = new StringBuilder(numbers.Length * 4 + 1);
            bool init = false;
            foreach (int n in numbers)
            {
                if (init)
                    sb.Append(',');
                else
                    init = true;
                sb.Append(n);
            }

            return sb.ToString();
        }
        public static int [] extructCommaSepLineFromInt(string source)
        {
            if (source == null)
                return EMPTY_INT_ARRAY;

            string [] words = source.Split(COMMA_VALUE);
            int[] retValue = new int[words.Length];

            try
            {
                for (int i = 0; i < words.Length; i++)
                {
                    retValue[i] = int.Parse(words[i]);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
                retValue = EMPTY_INT_ARRAY;
            }

            return retValue;
        }


        public static string decodeBase64URL(string source)
        {
            StringBuilder buf = new StringBuilder(128);
            char[] ch = new char[2];

            if (null == source)
            {
                return string.Empty;
            }
            int len = source.Length;
            for (int i = 0; i < len; i++)
            {
                char c = source[i];
                if ('%' == c && i + 2 < len)
                {
                    ch[0] = source[++i];
                    ch[1] = source[++i];
                    int n = int.Parse(new String(ch), NumberStyles.HexNumber);
                    buf.Append((char)n);
                }
                else
                {
                    buf.Append(c);
                }
            }

            Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
            return enc.GetString(Convert.FromBase64String(buf.ToString()));

        }

        public static string aesDecodeBase64URL(string source)
        {
            StringBuilder buf = new StringBuilder(128);
            char[] ch = new char[2];

            if (null == source)
            {
                return string.Empty;
            }
            int len = source.Length;
            for (int i = 0; i < len; i++)
            {
                char c = source[i];
                if ('%' == c && i + 2 < len)
                {
                    ch[0] = source[++i];
                    ch[1] = source[++i];
                    int n = int.Parse(new String(ch), NumberStyles.HexNumber);
                    buf.Append((char)n);
                }
                else
                {
                    buf.Append(c);
                }
            }
            byte[] b = Convert.FromBase64String(buf.ToString());
            MemoryStream byteStream = new MemoryStream(b);
            MemoryStream outStream;
            if (!NTCrypt.DecryptStream(byteStream, out outStream))
                return string.Empty;
            Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
            string result = enc.GetString(outStream.ToArray());
            outStream.Close();
            return result;

        }

        public static string encodeBase64URL(String source)
        {
            string resultStr = string.Empty;
            byte[] b;
            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                b = enc.GetBytes(source);
                string base64Str = Convert.ToBase64String(b);
                resultStr = percentEncode(base64Str);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return resultStr;

        }
        public static string aesEncodeBase64URL(String source)
        {
            string resultStr = string.Empty;
            byte[] b;
            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                b = enc.GetBytes(source);

                MemoryStream outStream;
                if(!NTCrypt.EncryptStream(new MemoryStream(b), out outStream))
                    return string.Empty;
                //outStream.Seek(0, SeekOrigin.Begin);
                //int len = (int)outStream.Length;
                byte[] outByte = outStream.ToArray();// new byte[len];
                //int ret = outStream.Read(outByte);
                string base64Str = Convert.ToBase64String(outByte);
                outStream.Close();
                resultStr = percentEncode(base64Str);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return resultStr;

        }

        public static string percentEncode(string source)
        {
            StringBuilder result = new StringBuilder(128);

            for (int i = 0; i < source.Length; i++)
            {
                char nVal = source[i];

                if (('a' <= nVal && nVal <= 'z') || ('A' <= nVal && nVal <= 'Z') || '0' <= nVal && nVal <= '9')
                {
                    result.Append(nVal);
                        
                }
                else
                {
                    //b = new byte[4];
                    //int len = enc.GetBytes(base64Str,i,1,b,0);
                    //if(len != 1)
                    //    return string.Empty;
                    char[] c = byteToHexChar(nVal);
                    result.Append('%').Append(c);
                }
            }
            return result.ToString();
        }

    }
}
