﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chCtrl;
using NT2chObject;

namespace NT2chView
{
    class NTVagueSearchWord : IAmbiguousSearch
    {
        public bool match(string source, 
            int startIndex, out int firstIndex, out int length)
        {
            firstIndex = length = -1;
            if (source == null || source.Length == 0)
                return false;

            firstIndex = match(source, startIndex, out length);
            return (firstIndex < 0) ? false : true;
        }

        class Tree
        {
            public char mC;
            public char mCode;
            public List<Tree> mTree = new List<Tree>();
            public Tree(char c) { mC = c; mCode = '\0'; }
        }

		Tree mParentTree;
		String mSearchWord = "";
		
		public NTVagueSearchWord(String searchWord){
			//DebugUtil.log("VagueSearchWord ctor with " + searchWord);
			mParentTree = new Tree('\0');
			setSearchWord(searchWord);
			
		}
		
		public void setSearchWord(String searchWord){
			String s = searchWord.Trim();
			if(mSearchWord.Equals(s)){
				return;
			}
			if(0 < s.Length){
				mParentTree = new Tree('\0');
				parseVagueString(mParentTree, s, 0);
			}
			mSearchWord = s;
			//debugPrintTree(mParentTree, "");
		}
		
		/*void debugPrintTree(Tree tree, String parent){
			List<Tree> treeArr = tree.mTree;
			for(int i = 0; i < treeArr.Count; i++){
				Tree newTree = treeArr[i];
				if(newTree.mCode == 1){
					char [] cc = new char[1];
					cc[0] = newTree.mC;
					//DebugUtil.log("Tree : " + (parent + new String(cc)));
				}else{
					char [] cc = new char[1];
					cc[0] = newTree.mC;
					debugPrintTree(newTree, (parent + new String(cc)));
				}
			}
		}*/
		
		public int compare(String source, int start){
			return match(mParentTree, source, start);
		}
		
		public int match(String source, int start, out int len){
			//DebugUtil.log("match() with " + source.substring(start));
			for(int i = start; i < source.Length; i++){
				int result = match(mParentTree, source, i);
				if(0 < result){
					//DebugUtil.log("matched!!! : " + source.substring(i, result));
					len = result;
					return i;
				}
			}
            len = -1;
			return -1;
		}
		int match(Tree tree, String source, int start){
			if(0 >= tree.mTree.Count){
				return -1;
			}
			if(start == source.Length){
				return -1;
			}
			
			char c = source[start];
			for(int i = 0; i < tree.mTree.Count; i++){
				Tree cTree = tree.mTree[i];
				if(cTree.mC == c){
					if(1 == cTree.mCode){
						return start + 1;
					}else{
						return match(cTree, source, start + 1);
					}
				}
			}
			return -1;
		}
		
		private void parseVagueString(Tree parentTree, String source, int start) {
			//DebugUtil.log("parseVagueString with "+ source.substring(start));
			char c = source[start];
			int index = findVagueChar(c);
			int nextIndex = start + 1;
			if(0 > index){
				Tree tree = new Tree(c);
				parentTree.mTree.Add(tree);
				if(nextIndex == source.Length){
					tree.mCode = (char)1;
				}else{
					parseVagueString(tree, source, nextIndex);
				}
			}else{
				char[] arr = vagueChar[index];
				for(int j = 0; j < arr.Length; j++){
					Tree tree = new Tree(arr[j]);
					parentTree.mTree.Add(tree);
					if(nextIndex == source.Length){
						tree.mCode = (char)1;
					}else{
						parseVagueString(tree, source, nextIndex);
					}				
				}
			}		
		}
	
		int findVagueChar(char c){
			for(int i = 0; i < vagueChar.Length; i++){
				for(int j = 0; j < vagueChar[i].Length; j++){
					if(c == vagueChar[i][j]){
						return i;
					}
				}
			}
			return -1;
		}
	
		char [][] vagueChar  = new char[][]{
			new []{'0','０'},new []{'1','１'},new []{'2','２'},
            new []{'3','３'},new []{'4','４'},new []{'5','５'},
			new []{'6','６'},new []{'7','７'},new []{'8','８'},new []{'9','９'},
			new []{'A','a','Ａ','ａ'},new []{'B','b','Ｂ','ｂ'},
            new []{'C','c','Ｃ','ｃ'},new []{'D','d','Ｄ','ｄ'},
            new []{'E','e','Ｅ','ｅ'},new []{'F','f','Ｆ','ｆ'},
			new []{'G','g','Ｇ','ｇ'},new []{'H','h','Ｈ','ｈ'},
            new []{'I','i','Ｉ','ｉ'},new []{'J','j','Ｊ','ｊ'},
            new []{'K','k','Ｋ','ｋ'},new []{'L','l','Ｌ','ｌ'},
			new []{'M','m','Ｍ','ｍ'},new []{'N','n','Ｎ','ｎ'},
            new []{'O','o','Ｏ','ｏ'},new []{'P','p','Ｐ','ｐ'},
            new []{'Q','q','Ｑ','ｑ'},new []{'R','r','Ｒ','ｒ'},
			new []{'S','s','Ｓ','ｓ'},new []{'T','t','Ｔ','ｔ'},
            new []{'U','u','Ｕ','ｕ'},new []{'V','v','Ｖ','ｖ'},
            new []{'W','w','Ｗ','ｗ'},new []{'X','x','Ｘ','ｘ'},
			new []{'Y','y','Ｙ','ｙ'},new []{'Z','z','Ｚ','ｚ'},
			new []{'あ','ア','ぁ','ァ'},new []{'い','イ','ぃ','ィ'},
            new []{'う','ウ','ぅ','ゥ'},new []{'え','エ','ぇ','ェ'},
            new []{'お','オ','ぉ','ォ','を','ヲ'},
			new []{'か','カ','ヵ','ヵ'},new []{'き','キ'},new []{'く','ク'},	
            new []{'け','ケ','ヶ','ヶ'},new []{'こ','コ'},new []{'さ','サ'},
            new []{'し','シ'},new []{'す','ス'},new []{'せ','セ'},
            new []{'そ','ソ'},new []{'た','タ'},new []{'ち','チ'},
            new []{'つ','ツ','っ','ッ'},new []{'て','テ'},new []{'と','ト'},
			new []{'な','ナ'},new []{'に','ニ'},new []{'ぬ','ヌ'},
            new []{'ね','ネ'},new []{'の','ノ'},new []{'は','ハ','ワ','わ'},
            new []{'ひ','ヒ'},new []{'ふ','フ'},new []{'へ','ヘ'},
            new []{'ほ','ホ'},new []{'ま','マ'},new []{'み','ミ'},
            new []{'む','ム'},new []{'め','メ'},new []{'も','モ'},
			new []{'や','ヤ','ゃ','ャ'},new []{'ゆ','ユ','ゅ','ュ'},
            new []{'よ','ヨ','ょ','ョ'},new[]{'ら','ラ','ﾗ'}, 
            new[]{'り','リ','ﾘ'},new[]{'る','ル','ﾙ'},new[]{'れ','レ','ﾚ'},
            new[]{'ろ','ロ','ﾛ'},new []{'ん','ン'},
			new []{'が','ガ'},new []{'ぎ','ギ'},new []{'ぐ','グ'},
            new []{'げ','ゲ'},new []{'ご','ゴ'},new []{'ざ','ザ'},
            new []{'じ','ジ','ぢ','ヂ'},new []{'ず','ズ','づ','ヅ'},
			new []{'ぜ','ゼ'},new []{'ぞ','ゾ'},new []{'だ','ダ'},
            new []{'で','デ'},new []{'ど','ド'},new []{'ば','バ'},
            new []{'び','ビ'},new []{'ぶ','ブ'},new []{'べ','ベ'},
            new []{'ぼ','ボ'},new []{'ぱ','パ'},new []{'ぴ','ピ'},
            new []{'ぷ','プ'},new []{'ぺ','ペ'},new []{'ぽ','ポ'},
			new []{'-','_','－','＿','ー','ｰ',' ','　'}
        };
    }
}
