/* 
 * PROJECT: NyARToolkitCS
 * --------------------------------------------------------------------------------
 * This work is based on the original ARToolKit developed by
 *   Hirokazu Kato
 *   Mark Billinghurst
 *   HITLab, University of Washington, Seattle
 * http://www.hitl.washington.edu/artoolkit/
 *
 * The NyARToolkitCS is C# edition ARToolKit class library.
 * Copyright (C)2008-2009 Ryo Iizuka
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 * 
 */
using jp.nyatla.nyartoolkit.cs.utils;
using System.Diagnostics;

namespace jp.nyatla.nyartoolkit.cs.core
{
    /**
     * 1̃O[XP[摜`NXłB摜f[^͓ێ/OێI\łB
     */
    public class NyARGrayscaleRaster : NyARRaster_BasicClass
    {
	    private IdoFilterImpl _impl;
	    protected object _buf;
	    /**
	     * obt@IuWFNgA^b`Ătrue
	     */
	    protected bool _is_attached_buffer;

        public NyARGrayscaleRaster(int i_width, int i_height)
            : base(i_width, i_height, NyARBufferType.INT1D_GRAY_8)
	    {
		    if (!initInstance(this._size, NyARBufferType.INT1D_GRAY_8, true))
		    {
			    throw new NyARException();
		    }
	    }
	    /**
	     * 
	     * @param i_width
	     * @param i_height
	     * @param i_is_alloc
	     * 摜obt@ێɂ邩̃tOlBtrueȂACX^Xobt@mۂ܂BfalseȂA
	     * 摜obt@͊OQƂɂȂAwrapBuffer֐gpł܂B
	     * @throws NyARException
	     */
        public NyARGrayscaleRaster(int i_width, int i_height, bool i_is_alloc)
            : base(i_width, i_height, NyARBufferType.INT1D_GRAY_8)
	    {
		    if (!initInstance(this._size, NyARBufferType.INT1D_GRAY_8, i_is_alloc))
		    {
			    throw new NyARException();
		    }
	    }

	    /**
	     * @param i_width
	     * @param i_height
	     * @param i_raster_type
	     *            NyARBufferTypeɒ`ꂽ萔lw肵ĂB
	     * @param i_is_alloc
	     * @throws NyARException
	     */
        public NyARGrayscaleRaster(int i_width, int i_height, int i_raster_type, bool i_is_alloc)
            : base(i_width, i_height, i_raster_type)
	    {
		    if (!initInstance(this._size, i_raster_type, i_is_alloc)) {
			    throw new NyARException();
		    }
	    }

	    /**
	     * ̃NX̏V[PXłBRXgN^Ăяo܂B
	     * @param i_size
	     * @param i_buf_type
	     * @param i_is_alloc
	     * @return
	     */
	    protected bool initInstance(NyARIntSize i_size, int i_buf_type,bool i_is_alloc)
	    {
		    switch (i_buf_type) {
		    case NyARBufferType.INT1D_GRAY_8:
			    this._impl=new IdoFilterImpl_INT1D_GRAY_8();
			    this._buf = i_is_alloc ? new int[i_size.w * i_size.h] : null;
			    break;
		    default:
			    return false;
		    }
		    this._is_attached_buffer = i_is_alloc;
		    return true;
	    }
	    public override object getBuffer()
	    {
		    return this._buf;
	    }

	    /**
	     * CX^Xobt@L邩Ԃ܂B RXgN^i_is_allocfalseɂăX^쐬ꍇA
	     * obt@ɃANZX܂ɁAobt@̗L̊֐Ń`FbNĂB
	     * @return
	     */
	    public override bool hasBuffer()
	    {
		    return this._buf != null;
	    }
	    /**
	     *@ǉ@\-B
	     * @throws NyARException 
	     */
        public override void wrapBuffer(object i_ref_buf)
	    {
		    Debug.Assert (!this._is_attached_buffer);// obt@A^b`Ă@\ȂB
		    this._buf = i_ref_buf;
	    }

	    /**
	     * w肵lŃX^𖄂߂܂B
	     * ̊֐͍Ă܂B
	     * @param i_value
	     */
	    public void fill(int i_value)
	    {
		   Debug.Assert (this.isEqualBufferType(this.getBufferType()));
		    this._impl.fill(this,i_value);
	    }

	    /**
	     * X^̈ى𑜓xԃRs[܂B
	     * @param i_input
	     * ̓X^
	     * @param i_top
	     * ̓X^̍_w肵܂B
	     * @param i_left
	     * ̓X^̍_w肵܂B
	     * @param i_skip
	     * skiplB1Ȃ瓙{A2Ȃ1/2{A3Ȃ1/3{̕Ώd̉摜o͂܂B
	     * @param o_output
	     * o͐惉X^B̃X^̉𑜓x́Aw=(i_input.w-i_left)/i_skip,h=(i_input.h-i_height)/i_skip𖞂Kv܂B
	     * o͐惉X^Ɠ̓X^̃obt@^Cv́AłKv܂B
	     */
	    public void copyTo(int i_left,int i_top,int i_skip, NyARGrayscaleRaster o_output)
	    {
		    Debug.Assert (this.getSize().isInnerSize(i_left + o_output.getWidth() * i_skip, i_top+ o_output.getHeight() * i_skip));		
		    Debug.Assert (this.isEqualBufferType(o_output.getBufferType()));
		    this._impl.copyTo(this, i_left, i_top, i_skip, o_output);
		    return;
	    }
	    ////////////////////////////////////////////////////////////////////////////////
	    //烉X^hCo
    	
	    interface IdoFilterImpl
	    {
		    void fill(NyARGrayscaleRaster i_raster,int i_value);
		    void copyTo(NyARGrayscaleRaster i_input, int i_left,int i_top,int i_skip, NyARGrayscaleRaster o_output);
	    }
    	
	    sealed class IdoFilterImpl_INT1D_GRAY_8 : IdoFilterImpl
	    {
		    public void fill(NyARGrayscaleRaster i_raster,int i_value)
		    {
			    Debug.Assert (i_raster._buffer_type == NyARBufferType.INT1D_GRAY_8);
			    int[] buf = (int[]) i_raster._buf;
			    for (int i = i_raster._size.h * i_raster._size.w - 1; i >= 0; i--) {
				    buf[i] = i_value;
			    }			
		    }

		    public void copyTo(NyARGrayscaleRaster i_input, int i_left,int i_top,int i_skip, NyARGrayscaleRaster o_output)
		    {
			    Debug.Assert (i_input.getSize().isInnerSize(i_left + o_output.getWidth() * i_skip, i_top+ o_output.getHeight() * i_skip));		
			    int[] input = (int[]) i_input.getBuffer();
			    int[] output = (int[]) o_output.getBuffer();
			    int pt_src, pt_dst;
			    NyARIntSize dest_size = o_output.getSize();
			    NyARIntSize src_size = i_input.getSize();
			    int skip_src_y = (src_size.w - dest_size.w * i_skip) + src_size.w * (i_skip - 1);
			    int pix_count = dest_size.w;
			    int pix_mod_part = pix_count - (pix_count % 8);
			    // ォ1sÂĂ
			    pt_dst = 0;
			    pt_src = (i_top * src_size.w + i_left);
			    for (int y = dest_size.h - 1; y >= 0; y -= 1) {
				    int x;
				    for (x = pix_count - 1; x >= pix_mod_part; x--) {
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
				    }
				    for (; x >= 0; x -= 8) {
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
					    output[pt_dst++] = input[pt_src];
					    pt_src += i_skip;
				    }
				    // XLbv
				    pt_src += skip_src_y;
			    }
			    return;
		    }
	    }	
    	
    }

}