/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions._CoordinatorImplBase;
import tyrex.tm.impl.ControlImpl;
import tyrex.tm.impl.TransactionImpl;

final class CoordinatorImpl
extends _CoordinatorImplBase
implements Coordinator {
    private final TransactionImpl _tx;
    private final TransIdentity[] _parents;
    private final ControlImpl _control;

    CoordinatorImpl(ControlImpl controlImpl) {
        if (controlImpl == null) {
            throw new IllegalArgumentException("Argument control is null");
        }
        this._control = controlImpl;
        this._tx = this._control._tx;
        this._parents = this._control._parents;
    }

    public Status get_parent_status() {
        if (this._parents == null) {
            return CoordinatorImpl.fromJTAStatus(this._tx.getStatus());
        }
        return this._parents[0].coord.get_status();
    }

    public Status get_status() {
        return CoordinatorImpl.fromJTAStatus(this._tx.getStatus());
    }

    public Status get_top_level_status() {
        if (this._parents == null) {
            return CoordinatorImpl.fromJTAStatus(this._tx.getStatus());
        }
        return this._parents[this._parents.length - 1].coord.get_status();
    }

    public boolean is_top_level_transaction() {
        return this._parents == null;
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        return this.hash_transaction() == coordinator.hash_transaction();
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        if (this._parents == null) {
            return this.is_same_transaction(coordinator);
        }
        int n = this._parents.length;
        while (n-- > 0) {
            if (this._parents[n].coord.is_ancestor_transaction(coordinator)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        return coordinator.is_descendant_transaction((Coordinator)this);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        if (this._parents == null) {
            return false;
        }
        int n = this._parents.length;
        while (n-- > 0) {
            if (!this._parents[n].coord.is_same_transaction(coordinator)) continue;
            return true;
        }
        return false;
    }

    public boolean is_top_level_transaction(Coordinator coordinator) {
        return this._parents == null;
    }

    public int hash_transaction() {
        return this._tx._hashCode;
    }

    public int hash_top_level_tran() {
        if (this._parents == null) {
            return this._tx._hashCode;
        }
        return this._parents[this._parents.length - 1].coord.hash_transaction();
    }

    public RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        try {
            this._tx.registerResource(resource);
            if (resource instanceof SubtransactionAwareResource) {
                this._tx.registerSynchronization(new SubtransactionAwareWrapper((SubtransactionAwareResource)resource, this));
            }
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
        return this._control;
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws Inactive, NotSubtransaction {
        if (this._parents == null) {
            throw new NotSubtransaction();
        }
        try {
            this._tx.registerSynchronization(new SubtransactionAwareWrapper(subtransactionAwareResource, this));
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        try {
            this._tx.registerSynchronization(new SynhronizationWrapper(synchronization));
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public void rollback_only() throws Inactive {
        try {
            this._tx.setRollbackOnly();
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public String get_transaction_name() {
        return this._tx.toString();
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        if (this._tx.getStatus() != 0 && this._tx.getStatus() != 1) {
            throw new Inactive();
        }
        try {
            TransactionImpl transactionImpl = this._tx._txDomain.createTransaction(this._tx, 0L);
            return transactionImpl.getControl();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public PropagationContext get_txcontext() {
        return this._control.getPropagationContext();
    }

    public Status replay_completion(Resource resource) {
        return this.get_status();
    }

    static Status fromJTAStatus(int n) {
        switch (n) {
            case 0: {
                return Status.StatusActive;
            }
            case 1: {
                return Status.StatusMarkedRollback;
            }
            case 8: {
                return Status.StatusCommitting;
            }
            case 3: {
                return Status.StatusCommitted;
            }
            case 9: {
                return Status.StatusRollingBack;
            }
            case 4: {
                return Status.StatusRolledBack;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 7: {
                return Status.StatusPreparing;
            }
            case 6: {
                return Status.StatusNoTransaction;
            }
        }
        return Status.StatusUnknown;
    }

    private static class SubtransactionAwareWrapper
    implements javax.transaction.Synchronization {
        private final SubtransactionAwareResource _aware;
        private final Coordinator _parent;

        SubtransactionAwareWrapper(SubtransactionAwareResource subtransactionAwareResource, Coordinator coordinator) {
            this._aware = subtransactionAwareResource;
            this._parent = coordinator;
        }

        public void beforeCompletion() {
            this._aware.commit_subtransaction(this._parent);
        }

        public void afterCompletion(int n) {
            if (n == 4) {
                this._aware.rollback_subtransaction();
            }
        }
    }

    private static class SynhronizationWrapper
    implements javax.transaction.Synchronization {
        private final Synchronization _sync;

        SynhronizationWrapper(Synchronization synchronization) {
            this._sync = synchronization;
        }

        public void afterCompletion(int n) {
            this._sync.after_completion(CoordinatorImpl.fromJTAStatus(n));
        }

        public void beforeCompletion() {
            this._sync.before_completion();
        }
    }
}

