/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator factoryMessageInterpolator;
    private final TraversableResolver factoryTraversableResolver;
    private final ConstraintValidatorFactory factoryConstraintValidatorFactory;
    private final BeanMetaDataManager beanMetaDataManager;
    private boolean failFast;

    public ValidatorContextImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator factoryMessageInterpolator, TraversableResolver factoryTraversableResolver, BeanMetaDataManager beanMetaDataManager, boolean failFast) {
        this.factoryConstraintValidatorFactory = constraintValidatorFactory;
        this.factoryMessageInterpolator = factoryMessageInterpolator;
        this.factoryTraversableResolver = factoryTraversableResolver;
        this.beanMetaDataManager = beanMetaDataManager;
        this.failFast = failFast;
        this.messageInterpolator(factoryMessageInterpolator);
        this.traversableResolver(factoryTraversableResolver);
        this.constraintValidatorFactory(this.factoryConstraintValidatorFactory);
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.factoryMessageInterpolator : messageInterpolator;
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.factoryTraversableResolver : traversableResolver;
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = this.constraintValidatorFactory == null ? this.factoryConstraintValidatorFactory : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public Validator getValidator() {
        return new ValidatorImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.beanMetaDataManager, this.failFast);
    }
}

