/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final AtomicInteger poolNumberGenerator;
    static final AtomicInteger nextSubmitterSeed;
    private static final RuntimePermission modifyThreadPermission;
    private static final ThreadSubmitter submitters;
    private static final long SHRINK_RATE = 4000000000L;
    private static final long SHRINK_TIMEOUT = 3600000000L;
    private static final int MAX_HELP = 64;
    private static final long COMPENSATION_DELAY = 262144L;
    private static final int SEED_INCREMENT = 1640531527;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int SMASK = 65535;
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final int SQMASK = 65534;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int E_SEQ = 65536;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 1;
    static final int SHARED_QUEUE = -1;
    volatile long ctl;
    final int parallelism;
    final int localMode;
    final int submitMask;
    int nextSeed;
    volatile int runState;
    WorkQueue[] workQueues;
    final Mutex lock;
    final Condition termination;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final AtomicLong stealCount;
    final AtomicInteger nextWorkerNumber;
    final String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private void addWorker() {
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            wt = this.factory.newThread(this);
            if (wt != null) {
                wt.start();
                return;
            }
        }
        catch (Throwable e) {
            ex = e;
        }
        this.deregisterWorker(wt, ex);
    }

    final String nextWorkerName() {
        return this.workerNamePrefix.concat(Integer.toString(this.nextWorkerNumber.addAndGet(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerWorker(WorkQueue w) {
        Mutex lock = this.lock;
        lock.lock();
        try {
            WorkQueue[] ws = this.workQueues;
            if (w != null && ws != null) {
                int n = ws.length;
                int m = n - 1;
                int s2 = this.nextSeed += 1640531527;
                w.seed = s2 == 0 ? 1 : s2;
                int r = s2 << 1 | 1;
                if (ws[r &= m] != null) {
                    int step;
                    int probes = 0;
                    int n2 = step = n <= 4 ? 2 : (n >>> 1 & 0xFFFE) + 2;
                    while (ws[r = r + step & m] != null) {
                        if (++probes < n) continue;
                        this.workQueues = ws = Arrays.copyOf(ws, n <<= 1);
                        m = n - 1;
                        probes = 0;
                    }
                }
                w.eventCount = w.poolIndex = r;
                ws[r] = w;
                int rs = this.runState;
                this.runState = rs & Integer.MIN_VALUE | rs + 2 & Integer.MAX_VALUE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        long c;
        Mutex lock = this.lock;
        WorkQueue w = null;
        if (wt != null && (w = wt.workQueue) != null) {
            w.runState = -1;
            this.stealCount.getAndAdd(w.totalSteals + (long)w.nsteals);
            int idx = w.poolIndex;
            lock.lock();
            try {
                WorkQueue[] ws = this.workQueues;
                if (ws != null && idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
            }
            finally {
                lock.unlock();
            }
        }
        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, c - 0x1000000000000L & 0xFFFF000000000000L | c - 0x100000000L & 0xFFFF00000000L | c & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && w != null) {
            w.cancelAll();
            if (w.array != null) {
                this.signalWork();
            }
            if (ex == null) {
                ForkJoinTask.helpExpungeStaleExceptions();
            }
        }
        if (ex != null) {
            U.throwException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doSubmit(ForkJoinTask<?> task) {
        s = (Submitter)ForkJoinPool.submitters.get();
        r = s.seed;
        m = this.submitMask;
        while (true) lbl-1000:
        // 6 sources

        {
            block12: {
                block11: {
                    k = r & m & 65534;
                    if (this.runState < 0) break block11;
                    ws = this.workQueues;
                    if (this.workQueues != null && ws.length > k) break block12;
                }
                throw new RejectedExecutionException();
            }
            q = ws[k];
            if (q == null) {
                nq = new WorkQueue(this, null, -1);
                lock = this.lock;
                lock.lock();
                try {
                    rs = this.runState;
                    if (ws != this.workQueues || ws[k] != null) ** GOTO lbl-1000
                    ws[k] = nq;
                    this.runState = rs & -2147483648 | rs + 2 & 0x7FFFFFFF;
                }
                finally {
                    lock.unlock();
                }
                continue;
            }
            if (q.trySharedPush(task)) {
                this.signalWork();
                return;
            }
            if (m > 1) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                s.seed = r;
                continue;
            }
            Thread.yield();
        }
    }

    final void incrementActiveCount() {
        long c;
        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, c + 0x1000000000000L)) {
        }
    }

    final void signalWork() {
        long c;
        int u;
        while ((u = (int)((c = this.ctl) >>> 32)) < 0) {
            long nc;
            WorkQueue[] ws = this.workQueues;
            int e = (int)c;
            if (e > 0) {
                WorkQueue w;
                int i;
                if (ws == null || (i = e & 0xFFFF) >= ws.length || (w = ws[i]) == null || w.eventCount != (e | Integer.MIN_VALUE)) break;
                nc = (long)(w.nextWait & Integer.MAX_VALUE) | (long)(u + 65536) << 32;
                if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
                w.eventCount = e + 65536 & Integer.MAX_VALUE;
                Thread p = w.parker;
                if (p == null) break;
                U.unpark(p);
                break;
            }
            if (e != 0 || (u & 0x8000) == 0) break;
            nc = (long)(u + 1 & 0xFFFF | u + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
            this.addWorker();
            break;
        }
    }

    final void runWorker(WorkQueue w) {
        w.growArray(false);
        do {
            w.runTask(this.scan(w));
        } while (w.runState >= 0);
    }

    private final ForkJoinTask<?> scan(WorkQueue w) {
        int m;
        int r = w.seed;
        r ^= r << 13;
        r ^= r >>> 17;
        r ^= r << 5;
        w.seed = r;
        int rs = this.runState;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0) {
            int ec = w.eventCount;
            int step = r >>> 16 | 1;
            int j = m + 1 << 2;
            while (true) {
                int b;
                WorkQueue q;
                if ((q = ws[r & m]) != null && (b = q.base) - q.top < 0) {
                    ForkJoinTask<?>[] a = q.array;
                    if (q.array != null) {
                        int i = ((a.length - 1 & b) << ASHIFT) + ABASE;
                        ForkJoinTask t = (ForkJoinTask)U.getObjectVolatile(a, i);
                        if (q.base == b && ec >= 0 && t != null && U.compareAndSwapObject(a, i, t, null)) {
                            q.base = b + 1;
                            return t;
                        }
                        if (ec < 0 || j <= m) {
                            rs = 0;
                            break;
                        }
                    }
                }
                if (--j < 0) break;
                r += step;
            }
            long c = this.ctl;
            int e = (int)c;
            int a = (int)(c >> 48);
            if (e < 0) {
                w.runState = -1;
            } else if (rs == 0 || rs != this.runState) {
                WorkQueue v;
                if (e > 0 && a < 0 && w.eventCount == ec && (v = ws[e & m]) != null && v.eventCount == (e | Integer.MIN_VALUE)) {
                    long nc = (long)(v.nextWait & Integer.MAX_VALUE) | c + 0x1000000000000L & 0xFFFFFFFF00000000L;
                    if (this.ctl == c && U.compareAndSwapLong(this, CTL, c, nc)) {
                        v.eventCount = e + 65536 & Integer.MAX_VALUE;
                        Thread p = v.parker;
                        if (p != null) {
                            U.unpark(p);
                        }
                    }
                }
            } else if (ec >= 0) {
                long nc = (long)ec | c - 0x1000000000000L & 0xFFFFFFFF00000000L;
                w.nextWait = e;
                w.eventCount = ec | Integer.MIN_VALUE;
                if (this.ctl != c || !U.compareAndSwapLong(this, CTL, c, nc)) {
                    w.eventCount = ec;
                } else {
                    int ns = w.nsteals;
                    if (ns != 0) {
                        w.nsteals = 0;
                        w.rescans = a > 0 ? 0 : a + this.parallelism;
                        w.totalSteals += (long)ns;
                    }
                    if (a == 1 - this.parallelism) {
                        this.idleAwaitWork(w, nc, c);
                    }
                }
            } else if (w.eventCount < 0) {
                int nr = w.rescans;
                if (nr > 0) {
                    int ac = a + this.parallelism;
                    w.rescans = ac < nr ? ac : nr - 1;
                    if ((w.rescans & 3) == 0) {
                        Thread.yield();
                    }
                } else {
                    Thread.interrupted();
                    Thread wt = Thread.currentThread();
                    U.putObject(wt, PARKBLOCKER, this);
                    w.parker = wt;
                    if (w.eventCount < 0) {
                        U.park(false, 0L);
                    }
                    w.parker = null;
                    U.putObject(wt, PARKBLOCKER, null);
                }
            }
        }
        return null;
    }

    private void idleAwaitWork(WorkQueue w, long currentCtl, long prevCtl) {
        if (w.eventCount < 0 && !this.tryTerminate(false, false) && (int)prevCtl != 0 && !this.hasQueuedSubmissions() && this.ctl == currentCtl) {
            Thread wt = Thread.currentThread();
            Thread.yield();
            while (this.ctl == currentCtl) {
                long startTime = System.nanoTime();
                Thread.interrupted();
                U.putObject(wt, PARKBLOCKER, this);
                w.parker = wt;
                if (this.ctl == currentCtl) {
                    U.park(false, 4000000000L);
                }
                w.parker = null;
                U.putObject(wt, PARKBLOCKER, null);
                if (this.ctl != currentCtl) break;
                if (System.nanoTime() - startTime < 3600000000L || !U.compareAndSwapLong(this, CTL, currentCtl, prevCtl)) continue;
                w.eventCount = w.eventCount + 65536 | Integer.MAX_VALUE;
                w.runState = -1;
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int tryHelpStealer(WorkQueue joiner, ForkJoinTask<?> task) {
        stat = 0;
        steps = 0;
        if (joiner != null && task != null) {
            block0: while (true) {
                subtask = task;
                j = joiner;
                while (true) {
                    block9: {
                        block8: {
                            if ((s = task.status) < 0) {
                                stat = s;
                                break block0;
                            }
                            ws = this.workQueues;
                            if (this.workQueues == null || (m = ws.length - 1) <= 0) break block0;
                            h = (j.stealHint | 1) & m;
                            v = ws[h];
                            if (v == null || v.currentSteal != subtask) {
                                origin = h;
                                do {
                                    if (((h = h + 2 & m) & 15) == 1 && (subtask.status < 0 || j.currentJoin != subtask)) continue block0;
                                    v = ws[h];
                                    if (v == null || v.currentSteal != subtask) continue;
                                    j.stealHint = h;
                                    break block8;
                                } while (h != origin);
                                break block0;
                            }
                        }
                        while (true) {
                            if (subtask.status < 0) continue block0;
                            b = v.base;
                            if (b - v.top >= 0) break block9;
                            a = v.array;
                            if (v.array == null) break block9;
                            i = ((a.length - 1 & b) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                            t = (ForkJoinTask)ForkJoinPool.U.getObjectVolatile(a, i);
                            if (subtask.status < 0 || j.currentJoin != subtask || v.currentSteal != subtask) continue block0;
                            stat = 1;
                            if (t != null && v.base == b && ForkJoinPool.U.compareAndSwapObject(a, i, t, null)) {
                                v.base = b + 1;
                                joiner.runSubtask(t);
                                continue;
                            }
                            if (v.base == b && ++steps == 64) break;
                        }
                        break block0;
                    }
                    next = v.currentJoin;
                    if (subtask.status >= 0 && j.currentJoin == subtask && v.currentSteal == subtask) ** break;
                    continue block0;
                    if (next == null || ++steps == 64) break block0;
                    subtask = next;
                    j = v;
                }
                break;
            }
        }
        return stat;
    }

    private void tryPollForAndExec(WorkQueue joiner, ForkJoinTask<?> task) {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int j = 1; j < ws.length && task.status >= 0; j += 2) {
                WorkQueue q = ws[j];
                if (q == null || !q.pollFor(task)) continue;
                joiner.runSubtask(task);
                break;
            }
        }
    }

    final boolean tryCompensate(ForkJoinTask<?> task, ManagedBlocker blocker) {
        int pc = this.parallelism;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        int e = (int)c;
        if (e >= 0 && ws != null) {
            WorkQueue w;
            int u = (int)(c >>> 32);
            int tc = (short)(u >>> 0) + pc;
            boolean replace = false;
            int a = u >> 16;
            if (a <= 0) {
                int hc;
                int ac = a + pc;
                if (ac <= 1) {
                    replace = true;
                } else if (e > 0 || task != null && ac <= (hc = pc >>> 1) && tc < pc + hc) {
                    for (int j = 0; j < ws.length; ++j) {
                        w = ws[j];
                        if (w == null || w.isEmpty()) continue;
                        replace = true;
                        break;
                    }
                }
            }
            if (!(task != null && task.status < 0 || blocker != null && blocker.isReleasable() || this.ctl != c)) {
                long nc;
                if (!replace) {
                    long nc2 = c - 0x1000000000000L & 0xFFFF000000000000L | c & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, c, nc2)) {
                        return true;
                    }
                } else if (e != 0) {
                    int i = e & 0xFFFF;
                    if (i < ws.length && (w = ws[i]) != null) {
                        long nc3 = (long)(w.nextWait & Integer.MAX_VALUE) | c & 0xFFFFFFFF00000000L;
                        if (w.eventCount == (e | Integer.MIN_VALUE) && U.compareAndSwapLong(this, CTL, c, nc3)) {
                            w.eventCount = e + 65536 & Integer.MAX_VALUE;
                            Thread p = w.parker;
                            if (p != null) {
                                U.unpark(p);
                            }
                            return true;
                        }
                    }
                } else if (tc < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL)) {
                    this.addWorker();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int awaitJoin(WorkQueue joiner, ForkJoinTask<?> task) {
        int s2 = task.status;
        if (s2 >= 0) {
            ForkJoinTask<?> prevJoin = joiner.currentJoin;
            joiner.currentJoin = task;
            long startTime = 0L;
            int k = 0;
            while (true) {
                if ((s2 = joiner.isEmpty() ? this.tryHelpStealer(joiner, task) : joiner.tryRemoveAndExec(task)) == 0 && (s2 = task.status) >= 0) {
                    if (k == 0) {
                        startTime = System.nanoTime();
                        this.tryPollForAndExec(joiner, task);
                    } else if ((k & 0x3F) == 0 && System.nanoTime() - startTime >= 262144L && this.tryCompensate(task, null)) {
                        long c;
                        if (task.trySetSignal()) {
                            ForkJoinTask<?> forkJoinTask = task;
                            synchronized (forkJoinTask) {
                                if (task.status >= 0) {
                                    try {
                                        task.wait();
                                    }
                                    catch (InterruptedException ie) {}
                                } else {
                                    task.notifyAll();
                                }
                            }
                        }
                        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, c + 0x1000000000000L)) {
                        }
                    }
                }
                if (s2 < 0 || (s2 = task.status) < 0) {
                    joiner.currentJoin = prevJoin;
                    break;
                }
                if ((k++ & 0x3F) != 32) continue;
                Thread.yield();
            }
        }
        return s2;
    }

    final int helpJoinOnce(WorkQueue joiner, ForkJoinTask<?> task) {
        int s2;
        while ((s2 = task.status) >= 0 && (joiner.isEmpty() ? this.tryHelpStealer(joiner, task) : joiner.tryRemoveAndExec(task)) != 0) {
        }
        return s2;
    }

    private WorkQueue findNonEmptyStealQueue(WorkQueue w) {
        int r = w.seed;
        r ^= r << 13;
        r ^= r >>> 17;
        r ^= r << 5;
        w.seed = r;
        int step = r >>> 16 | 1;
        block0: while (true) {
            int m;
            int rs = this.runState;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (m = ws.length - 1) < 1) {
                return null;
            }
            int j = m + 1 << 2;
            while (true) {
                WorkQueue q;
                if ((q = ws[(r << 1 | 1) & m]) != null && !q.isEmpty()) {
                    return q;
                }
                if (--j < 0) {
                    if (this.runState != rs) continue block0;
                    return null;
                }
                r += step;
            }
            break;
        }
    }

    final void helpQuiescePool(WorkQueue w) {
        long c;
        boolean active = true;
        while (true) {
            ForkJoinTask<?> localTask;
            if ((localTask = w.nextLocalTask()) != null) {
                localTask.doExec();
                continue;
            }
            WorkQueue q = this.findNonEmptyStealQueue(w);
            if (q != null) {
                ForkJoinTask<?> t;
                int b;
                if (!active) {
                    long c2;
                    active = true;
                    while (!U.compareAndSwapLong(this, CTL, c2 = this.ctl, c2 + 0x1000000000000L)) {
                    }
                }
                if ((b = q.base) - q.top >= 0 || (t = q.pollAt(b)) == null) continue;
                w.runSubtask(t);
                continue;
            }
            if (active) {
                active = false;
                do {
                    c = this.ctl;
                } while (!U.compareAndSwapLong(this, CTL, c, c -= 0x1000000000000L));
            } else {
                c = this.ctl;
            }
            if ((int)(c >> 48) + this.parallelism == 0) break;
        }
        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, c + 0x1000000000000L)) {
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        ForkJoinTask<?> t;
        WorkQueue q;
        int b;
        do {
            if ((t = w.nextLocalTask()) != null) {
                return t;
            }
            q = this.findNonEmptyStealQueue(w);
            if (q != null) continue;
            return null;
        } while ((b = q.base) - q.top >= 0 || (t = q.pollAt(b)) == null);
        return t;
    }

    final int idlePerActive() {
        int p = this.parallelism;
        int a = p + (int)(this.ctl >> 48);
        return a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8)));
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        lock = this.lock;
        block0: while (true) {
            if (((c = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(c >>> 32) == -this.parallelism) {
                    lock.lock();
                    this.termination.signalAll();
                    lock.unlock();
                }
                return true;
            }
            if (this.runState >= 0) {
                if (!enable) {
                    return false;
                }
                lock.lock();
                this.runState |= -2147483648;
                lock.unlock();
            }
            if (!now) {
                if ((int)(c >> 48) != -this.parallelism || this.hasQueuedSubmissions()) {
                    return false;
                }
                ws = this.workQueues;
                if (ws != null) {
                    for (i = 1; i < ws.length; i += 2) {
                        w = ws[i];
                        if (w == null || w.eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, c, c | 0x80000000L)) continue;
            pass = 0;
            while (true) {
                if (pass < 3) ** break;
                continue block0;
                ws = this.workQueues;
                if (ws != null) {
                    n = ws.length;
                    for (i = 0; i < n; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        w.runState = -1;
                        if (pass <= 0) continue;
                        w.cancelAll();
                        if (pass <= 1) continue;
                        w.interruptOwner();
                    }
                    while ((e = (int)(cc = this.ctl) & 0x7FFFFFFF) != 0 && (i = e & 65535) < n && (w = ws[i]) != null) {
                        nc = (long)(w.nextWait & 0x7FFFFFFF) | cc + 0x1000000000000L & -281474976710656L | cc & 0xFFFF80000000L;
                        if (w.eventCount != (e | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, cc, nc)) continue;
                        w.eventCount = e + 65536 & 0x7FFFFFFF;
                        w.runState = -1;
                        p = w.parker;
                        if (p == null) continue;
                        ForkJoinPool.U.unpark(p);
                    }
                }
                ++pass;
            }
            break;
        }
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        ForkJoinPool.checkPermission();
        if (factory == null) {
            throw new NullPointerException();
        }
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = parallelism;
        this.factory = factory;
        this.ueh = handler;
        this.localMode = asyncMode ? 1 : 0;
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
        int n = parallelism - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        int size2 = n + 1 << 1;
        this.submitMask = size2 - 1;
        this.workQueues = new WorkQueue[size2];
        this.lock = new Mutex();
        this.termination = this.lock.newCondition();
        this.stealCount = new AtomicLong();
        this.nextWorkerNumber = new AtomicInteger();
        int pn = poolNumberGenerator.incrementAndGet();
        StringBuilder sb = new StringBuilder("ForkJoinPool-");
        sb.append(Integer.toString(pn));
        sb.append("-worker-");
        this.workerNamePrefix = sb.toString();
        this.lock.lock();
        this.runState = 1;
        this.lock.unlock();
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        this.doSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
        return task;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        ForkJoinTask.AdaptedCallable<T> job = new ForkJoinTask.AdaptedCallable<T>(task);
        this.doSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result2) {
        ForkJoinTask.AdaptedRunnable<T> job = new ForkJoinTask.AdaptedRunnable<T>(task, result2);
        this.doSubmit(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        this.doSubmit(job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> fs;
        ArrayList<Future<T>> futures = fs = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
                this.doSubmit(adaptedCallable);
                fs.add(adaptedCallable);
            }
            for (ForkJoinTask forkJoinTask : fs) {
                forkJoinTask.quietlyJoin();
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (ForkJoinTask forkJoinTask : fs) {
                    forkJoinTask.cancel(false);
                }
            }
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.localMode != 0;
    }

    public int getRunningThreadCount() {
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || !w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = this.parallelism + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        return (int)(this.ctl >> 48) + this.parallelism == 0;
    }

    public long getStealCount() {
        long count2 = this.stealCount.get();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count2 += w.totalSteals;
            }
        }
        return count2;
    }

    public long getQueuedTaskCount() {
        long count2 = 0L;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count2 += (long)w.queueSize();
            }
        }
        return count2;
    }

    public int getQueuedSubmissionCount() {
        int count2 = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count2 += w.queueSize();
            }
        }
        return count2;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || w.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null || (t = w.poll()) == null) continue;
                return t;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count2 = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null) continue;
                while ((t = w.poll()) != null) {
                    c.add(t);
                    ++count2;
                }
            }
        }
        return count2;
    }

    public String toString() {
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        long st = this.stealCount.get();
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size2 = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size2;
                    continue;
                }
                qt += (long)size2;
                st += w.totalSteals;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = this.parallelism;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (c & 0x80000000L) != 0L ? (tc == 0 ? "Terminated" : "Terminating") : (this.runState < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long c = this.ctl;
        return (c & 0x80000000L) != 0L && (short)(c >>> 32) == -this.parallelism;
    }

    public boolean isTerminating() {
        long c = this.ctl;
        return (c & 0x80000000L) != 0L && (short)(c >>> 32) != -this.parallelism;
    }

    @Override
    public boolean isShutdown() {
        return this.runState < 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Mutex lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        ForkJoinPool p;
        Thread t = Thread.currentThread();
        ForkJoinPool forkJoinPool = p = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
        while (!blocker.isReleasable()) {
            if (p != null && !p.tryCompensate(null, blocker)) continue;
            try {
                while (!blocker.isReleasable() && !blocker.block()) {
                }
                break;
            }
            finally {
                if (p != null) {
                    p.incrementActiveCount();
                }
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value2) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value2);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static Unsafe getUnsafe() {
        return scala.concurrent.util.Unsafe.instance;
    }

    static {
        int s2;
        poolNumberGenerator = new AtomicInteger();
        nextSubmitterSeed = new AtomicInteger(0x55555555);
        modifyThreadPermission = new RuntimePermission("modifyThread");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        submitters = new ThreadSubmitter();
        try {
            U = ForkJoinPool.getUnsafe();
            Class<ForkJoinPool> k = ForkJoinPool.class;
            Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
            CTL = U.objectFieldOffset(k.getDeclaredField("ctl"));
            Class<Thread> tk = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            ABASE = U.arrayBaseOffset(ak);
            s2 = U.arrayIndexScale(ak);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((s2 & s2 - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(s2);
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class ThreadSubmitter
    extends ThreadLocal<Submitter> {
        ThreadSubmitter() {
        }

        @Override
        public Submitter initialValue() {
            return new Submitter();
        }
    }

    static final class Submitter {
        int seed;

        Submitter() {
            int s2 = nextSubmitterSeed.getAndAdd(1640531527);
            this.seed = s2 == 0 ? 1 : s2;
        }
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile long totalSteals;
        int seed;
        volatile int eventCount;
        int nextWait;
        int rescans;
        int nsteals;
        final int mode;
        int poolIndex;
        int stealHint;
        volatile int runState;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        Object p00;
        Object p01;
        Object p02;
        Object p03;
        Object p04;
        Object p05;
        Object p06;
        Object p07;
        Object p08;
        Object p09;
        Object p0a;
        Object p0b;
        Object p0c;
        Object p0d;
        Object p0e;
        private static final Unsafe U;
        private static final long RUNSTATE;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner, int mode) {
            this.mode = mode;
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int s2 = this.top;
            int n = this.base - s2;
            if (n >= 0) return true;
            if (n != -1) return false;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return true;
            int m = a.length - 1;
            if (m < 0) return true;
            if (U.getObjectVolatile(a, ((m & s2 - 1) << ASHIFT) + ABASE) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            int s2 = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null) {
                int m = a.length - 1;
                U.putOrderedObject(a, ((m & s2) << ASHIFT) + ABASE, task);
                this.top = s2 + 1;
                int n = this.top - this.base;
                if (n <= 2) {
                    ForkJoinPool p = this.pool;
                    if (p != null) {
                        p.signalWork();
                    }
                } else if (n >= m) {
                    this.growArray(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean trySharedPush(ForkJoinTask<?> task) {
            boolean submitted = false;
            if (this.runState == 0 && U.compareAndSwapInt(this, RUNSTATE, 0, 1)) {
                ForkJoinTask<?>[] a = this.array;
                int s2 = this.top;
                try {
                    if (a != null && a.length > s2 + 1 - this.base || (a = this.growArray(false)) != null) {
                        int j = ((a.length - 1 & s2) << ASHIFT) + ABASE;
                        U.putObject(a, j, task);
                        this.top = s2 + 1;
                        submitted = true;
                    }
                }
                finally {
                    this.runState = 0;
                }
            }
            return submitted;
        }

        final ForkJoinTask<?> pop() {
            int m;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (m = a.length - 1) >= 0) {
                long j;
                ForkJoinTask t;
                int s2;
                while ((s2 = this.top - 1) - this.base >= 0 && (t = (ForkJoinTask)U.getObject(a, j = (long)(((m & s2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(a, j, t, null)) continue;
                    this.top = s2;
                    return t;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int b) {
            int j;
            ForkJoinTask t;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (t = (ForkJoinTask)U.getObjectVolatile(a, j = ((a.length - 1 & b) << ASHIFT) + ABASE)) != null && this.base == b && U.compareAndSwapObject(a, j, t, null)) {
                this.base = b + 1;
                return t;
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int b;
            while ((b = this.base) - this.top < 0) {
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null) break;
                int j = ((a.length - 1 & b) << ASHIFT) + ABASE;
                ForkJoinTask t = (ForkJoinTask)U.getObjectVolatile(a, j);
                if (t != null) {
                    if (this.base != b || !U.compareAndSwapObject(a, j, t, null)) continue;
                    this.base = b + 1;
                    return t;
                }
                if (this.base != b) continue;
                if (b + 1 == this.top) break;
                Thread.yield();
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.mode == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int m;
            ForkJoinTask<?>[] a = this.array;
            if (a == null || (m = a.length - 1) < 0) {
                return null;
            }
            int i = this.mode == 0 ? this.top - 1 : this.base;
            int j = ((i & m) << ASHIFT) + ABASE;
            return (ForkJoinTask)U.getObjectVolatile(a, j);
        }

        final boolean tryUnpush(ForkJoinTask<?> t) {
            int s2;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (s2 = this.top) != this.base && U.compareAndSwapObject(a, ((a.length - 1 & --s2) << ASHIFT) + ABASE, t, null)) {
                this.top = s2;
                return true;
            }
            return false;
        }

        final boolean pollFor(ForkJoinTask<?> task) {
            int b = this.base;
            if (b - this.top < 0) {
                int j;
                ForkJoinTask<?>[] a = this.array;
                if (this.array != null && U.getObjectVolatile(a, j = ((a.length - 1 & b) << ASHIFT) + ABASE) == task && this.base == b && U.compareAndSwapObject(a, j, task, null)) {
                    this.base = b + 1;
                    return true;
                }
            }
            return false;
        }

        final ForkJoinTask<?>[] growArray(boolean rejectOnFailure) {
            int size2;
            ForkJoinTask<?>[] oldA = this.array;
            int n = size2 = oldA != null ? oldA.length << 1 : 8192;
            if (size2 <= 0x4000000) {
                int b;
                int t;
                int oldMask;
                this.array = new ForkJoinTask[size2];
                ForkJoinTask[] a = this.array;
                if (oldA != null && (oldMask = oldA.length - 1) >= 0 && (t = this.top) - (b = this.base) > 0) {
                    int mask = size2 - 1;
                    do {
                        int oldj = ((b & oldMask) << ASHIFT) + ABASE;
                        int j = ((b & mask) << ASHIFT) + ABASE;
                        ForkJoinTask x = (ForkJoinTask)U.getObjectVolatile(oldA, oldj);
                        if (x == null || !U.compareAndSwapObject(oldA, oldj, x, null)) continue;
                        U.putObjectVolatile(a, j, x);
                    } while (++b != t);
                }
                return a;
            }
            if (!rejectOnFailure) {
                return null;
            }
            throw new RejectedExecutionException("Queue capacity exceeded");
        }

        final void cancelAll() {
            ForkJoinTask<?> t;
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while ((t = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }

        final int nextSeed() {
            int r = this.seed;
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
            this.seed = r;
            return r;
        }

        private void popAndExecAll() {
            while (true) {
                long j;
                ForkJoinTask t;
                int s2;
                int m;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (m = a.length - 1) < 0 || (s2 = this.top - 1) - this.base < 0 || (t = (ForkJoinTask)U.getObject(a, j = (long)(((m & s2) << ASHIFT) + ABASE))) == null) break;
                if (!U.compareAndSwapObject(a, j, t, null)) continue;
                this.top = s2;
                t.doExec();
            }
        }

        private void pollAndExecAll() {
            ForkJoinTask<?> t;
            while ((t = this.poll()) != null) {
                t.doExec();
            }
        }

        final int tryRemoveAndExec(ForkJoinTask<?> task) {
            int b;
            int s2;
            int n;
            int m;
            int stat = 1;
            boolean removed = false;
            boolean empty = true;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (m = a.length - 1) >= 0 && (n = (s2 = this.top) - (b = this.base)) > 0) {
                int j;
                ForkJoinTask t;
                while ((t = (ForkJoinTask)U.getObjectVolatile(a, j = ((--s2 & m) << ASHIFT) + ABASE)) != null) {
                    if (t == task) {
                        if (s2 + 1 == this.top) {
                            if (!U.compareAndSwapObject(a, j, task, null)) break;
                            this.top = s2;
                            removed = true;
                            break;
                        }
                        if (this.base != b) break;
                        removed = U.compareAndSwapObject(a, j, task, new EmptyTask());
                        break;
                    }
                    if (t.status >= 0) {
                        empty = false;
                    } else if (s2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(a, j, t, null)) break;
                        this.top = s2;
                        break;
                    }
                    if (--n != 0) continue;
                    if (empty || this.base != b) break;
                    stat = 0;
                    break;
                }
            }
            if (removed) {
                task.doExec();
            }
            return stat;
        }

        final void runTask(ForkJoinTask<?> t) {
            if (t != null) {
                this.currentSteal = t;
                t.doExec();
                if (this.top != this.base) {
                    if (this.mode == 0) {
                        this.popAndExecAll();
                    } else {
                        this.pollAndExecAll();
                    }
                }
                ++this.nsteals;
                this.currentSteal = null;
            }
        }

        final void runSubtask(ForkJoinTask<?> t) {
            if (t != null) {
                ForkJoinTask<?> ps = this.currentSteal;
                this.currentSteal = t;
                t.doExec();
                this.currentSteal = ps;
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s2;
            ForkJoinWorkerThread wt;
            return this.eventCount >= 0 && (wt = this.owner) != null && (s2 = wt.getState()) != Thread.State.BLOCKED && s2 != Thread.State.WAITING && s2 != Thread.State.TIMED_WAITING;
        }

        final void interruptOwner() {
            Thread p;
            ForkJoinWorkerThread wt = this.owner;
            if (wt != null && !wt.isInterrupted()) {
                try {
                    wt.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((p = this.parker) != null) {
                U.unpark(p);
            }
        }

        static {
            int s2;
            try {
                U = ForkJoinPool.getUnsafe();
                Class<WorkQueue> k = WorkQueue.class;
                Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
                RUNSTATE = U.objectFieldOffset(k.getDeclaredField("runState"));
                ABASE = U.arrayBaseOffset(ak);
                s2 = U.arrayIndexScale(ak);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            if ((s2 & s2 - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(s2);
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void x) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class Mutex
    extends AbstractQueuedSynchronizer {
        Mutex() {
        }

        @Override
        public final boolean tryAcquire(int ignore) {
            return this.compareAndSetState(0, 1);
        }

        @Override
        public final boolean tryRelease(int ignore) {
            this.setState(0);
            return true;
        }

        public final void lock() {
            this.acquire(0);
        }

        public final void unlock() {
            this.release(0);
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        public final Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

