package models
import org.squeryl.KeyedEntity
import org.squeryl.dsl._
import org.squeryl.PrimitiveTypeMode._
import forms._
case class Part(var name:String, atach:AtachForm, var cost: Long, var projectId:Long=0) extends AbstractModel{
  val id:Long=0

  lazy val parts = PartsListDb.partRelations.left(this)
  lazy val atachs : OneToMany[Atach] = PartsListDb.partsAtache.left(this)
//  lazy val parts = PartsListDb.partRelations.left(this).page(0, 1)
  lazy val parentParts = PartsListDb.partRelations.right(this)
  lazy val project : ManyToOne[Project] = PartsListDb.projectParts.right(this)
  lazy val notifies : OneToMany[Notify] = PartsListDb.partsNotifies.left(this)
  def partRelation(cId:Long):PartRelation = PartsListDb.partRelations.where(pr => pr.parentId === this.id and pr.childId === cId).head
}