package models
import org.squeryl._
import org.squeryl.dsl._
case class Reply(message:String, replyUserId: Long, notifyId: Long, replyId: Long) extends KeyedEntity[Long]{
	val id: Long = 0
	lazy val parentNotify: ManyToOne[Notify] = PartsListDb.NotifyReplies.right(this)
	lazy val user: ManyToOne[User] = PartsListDb.userReplies.right(this)
	lazy val childReplies: OneToMany[Reply] = PartsListDb.replyRelations.left(this)
	lazy val parentReply: ManyToOne[Reply] = PartsListDb.replyRelations.right(this)
}