/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;

public class WeakList {
    private Reference[] _table;
    private static ReferenceQueue _queue = new ReferenceQueue();
    public static final int INITIAL_SIZE = 2;
    static /* synthetic */ Class class$java$lang$Integer;

    public void add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object is null");
        }
        if (this._table == null) {
            this._table = new Reference[2];
            this._table[0] = new WeakReference<Object>(object, _queue);
        } else {
            int n;
            this.processQueue();
            Reference[] referenceArray = this._table;
            int n2 = n = referenceArray.length;
            while (n2-- > 0) {
                if (referenceArray[n2] != null && referenceArray[n2].get() != null) continue;
                referenceArray[n2] = new WeakReference<Object>(object, _queue);
                return;
            }
            Reference[] referenceArray2 = new Reference[n * 2];
            int n3 = n;
            while (n3-- > 0) {
                referenceArray2[n3] = referenceArray[n3];
            }
            referenceArray2[n] = new WeakReference<Object>(object, _queue);
            this._table = referenceArray2;
        }
    }

    public Object remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object is null");
        }
        Reference[] referenceArray = this._table;
        if (referenceArray == null) {
            return null;
        }
        this.processQueue();
        int n = referenceArray.length;
        while (n-- > 0) {
            Reference reference = referenceArray[n];
            if (reference == null || reference.get() != object) continue;
            referenceArray[n] = null;
            return object;
        }
        return null;
    }

    public void clear() {
        Reference[] referenceArray = this._table;
        if (referenceArray != null) {
            int n = referenceArray.length;
            while (n-- > 0) {
                referenceArray[n] = null;
            }
            referenceArray = null;
        }
        this.processQueue();
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object is null");
        }
        Reference[] referenceArray = this._table;
        if (referenceArray == null) {
            return false;
        }
        this.processQueue();
        int n = referenceArray.length;
        while (n-- > 0) {
            Reference reference = referenceArray[n];
            if (reference == null || reference.get() != object) continue;
            return true;
        }
        return false;
    }

    public Object[] list() {
        Reference[] referenceArray = this._table;
        if (referenceArray == null) {
            return new Object[0];
        }
        int n = referenceArray.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        int n3 = n;
        while (n3-- > 0) {
            Object t;
            Reference reference = referenceArray[n3];
            if (reference == null || (t = reference.get()) == null) continue;
            objectArray[n2] = t;
            ++n2;
        }
        if (n2 == 0) {
            return new Object[0];
        }
        return objectArray;
    }

    public Object[] list(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument type is null");
        }
        Reference[] referenceArray = this._table;
        if (referenceArray == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        int n = referenceArray.length;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        int n3 = n;
        while (n3-- > 0) {
            Object t;
            Reference reference = referenceArray[n3];
            if (reference == null || (t = reference.get()) == null || !clazz.isAssignableFrom(t.getClass())) continue;
            objectArray[n2] = t;
            ++n2;
        }
        if (n2 == 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        return objectArray;
    }

    private void processQueue() {
        Reference reference = _queue.poll();
        Reference[] referenceArray = this._table;
        while (reference != null) {
            int n = referenceArray.length;
            while (n-- > 0) {
                if (referenceArray[n] != reference) continue;
                referenceArray[n] = null;
                break;
            }
            reference = _queue.poll();
        }
    }

    public static void main(String[] stringArray) {
        try {
            Integer n = new Integer(1);
            Integer n2 = new Integer(2);
            WeakList weakList = new WeakList();
            System.out.println("First try: one and two");
            weakList.add(n);
            weakList.add(n2);
            Integer[] integerArray = (Integer[])weakList.list(class$java$lang$Integer == null ? (class$java$lang$Integer = WeakList.class$("java.lang.Integer")) : class$java$lang$Integer);
            int n3 = 0;
            while (n3 < integerArray.length) {
                System.out.println(integerArray[n3]);
                integerArray[n3] = null;
                ++n3;
            }
            integerArray = null;
            n2 = null;
            Runtime.getRuntime().gc();
            System.out.println("Second try: one only");
            integerArray = (Integer[])weakList.list(class$java$lang$Integer == null ? (class$java$lang$Integer = WeakList.class$("java.lang.Integer")) : class$java$lang$Integer);
            int n4 = 0;
            while (n4 < integerArray.length) {
                System.out.println(integerArray[n4]);
                integerArray[n4] = null;
                ++n4;
            }
            integerArray = null;
            n = null;
            Runtime.getRuntime().gc();
            System.out.println("Third try: empty");
            integerArray = (Integer[])weakList.list(class$java$lang$Integer == null ? (class$java$lang$Integer = WeakList.class$("java.lang.Integer")) : class$java$lang$Integer);
            int n5 = 0;
            while (n5 < integerArray.length) {
                System.out.println(integerArray[n5]);
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

