/*
 * OpenI2CRADIO
 * RADIO CHIP AKC6955 Handler
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#ifdef __SDCC
#include <delay.h>
#else
#include <xc.h>
#endif
#include <string.h>
#include "akc6955.h"
#include "i2c_io.h"
#include "idle.h"
#include "power.h"
#include "commondef.h"
#include "menu.h"
#include "ui.h"

unsigned char akc6955_readcmd(unsigned char reg)
{
   return i2c_read_byte(AKC6955_ADDRESS, reg);
}

void akc6955_writecmd(unsigned char reg,unsigned char data)
{
    i2c_send_byte(AKC6955_ADDRESS, reg, data);
}

unsigned char akc6955_get_band(void)
{
    return akc6955_readcmd(AKC6955_BAND);
}

unsigned char akc6955_get_amband(void)
{
   return akc6955_get_band() >> 3; 
}

unsigned char akc6955_get_fmband(void)
{
   return akc6955_get_band() & 0x07; 
}


void akc6955_chg_fm(unsigned char f, unsigned int freq)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_POWER);
    b.b6 = 0;
    if(f != 0){
        b.b6 = 1;
        akc6955_set_fmband(setup.fmband);
        akc6955_writecmd(AKC6955_POWER, b.byte);
        akc6955_set_freq(freq);
        return;
    }
    akc6955_writecmd(AKC6955_POWER, b.byte);
    akc6955_set_amband(setup.amband);
    akc6955_set_freq(freq);

}

unsigned char akc6955_get_fm(void)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_POWER);
    if(b.b6){
        return 0xff;
    }
    return 0;
}


void akc6955_set_amband(unsigned char band)
{
    unsigned char b;
    unsigned char c;

    c = RFAMP_SW;
    if((band < AKC6955_BAND_SW1) || (band == AKC6955_BAND_MW4)) {
        c = RFAMP_MWLW;
    }
    rfamp_power(c);
    b = akc6955_readcmd(AKC6955_BAND);
    b &= 0x07; // extract FM
    b = b | ((band & 0x1f) << 3);
    akc6955_writecmd(AKC6955_BAND, b);
    akc6955_do_tune();
}

void akc6955_set_fmband(unsigned char band)
{
    unsigned char b;
    rfamp_power(RFAMP_FM);
    b = akc6955_readcmd(AKC6955_BAND);
    b &= 0xf8; // extract AM
    b = b | (band & 0x07);
    akc6955_writecmd(AKC6955_BAND, b);
    akc6955_do_tune();
}

void akc6955_set_power(unsigned char on)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_POWER);
    b.b7 = 0;
    if(on != 0){
        b.b7 = 1;
    }
    akc6955_writecmd(AKC6955_POWER, b.byte);
}

void akc6955_do_tune(void)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_POWER) & 0b11001111;
//    b.b5 = 0; // Tun = '0'
//    b.b4 = 0; // Force abort scan.
    akc6955_writecmd(AKC6955_POWER, b.byte);
    idle_time_ms(1);
    // Need sleep?-> Need! this sequence re                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 fer from reference code.
    b.b5= 1; // Tun = '1'
    akc6955_writecmd(AKC6955_POWER, b.byte);
    idle_time_ms(1);
    b.b5 = 0;
    akc6955_writecmd(AKC6955_POWER, b.byte);
    idle_time_ms(8);
}

unsigned char akc6955_tune(void)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_RCH_HI);
    if(b.b5) {
        return 0xff;
    }
    return 0;
}


void akc6955_mode3k(unsigned char flag)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_CH_LO);
    akc6955_writecmd(AKC6955_CH_LO, b.byte);

    b.byte = akc6955_readcmd(AKC6955_CH_HI);
    b.b5 = 0;
    if(flag != 0){
        b.b5 = 1;
    }
    akc6955_writecmd(AKC6955_CH_HI, b.byte);
    akc6955_do_tune();
}

unsigned char akc6955_get_mode3k(void)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_CNR_AM);
    if(c.b7) {
        return 0xff;
    }
    return 0;
}

void akc6955_set_tune(unsigned char mode_3k, unsigned int ch)
{
    unsigned char band;
    unsigned char f;
    __bitops_t b;
    unsigned int i = ch;
    unsigned int start, stop;
    unsigned char q;

    while(akc6955_chk_donescan() == 0) { // Wait for before completed
        idle_time_35ms();
    }
    f = akc6955_get_fm();
    band = 0;
    if(f == 0){
        band = akc6955_get_amband();
        if(band == AKC6955_BAND_AMUSER){
            start = userband.am_usrbands[setup.am_userbandnum].start * 32;
            stop = userband.am_usrbands[setup.am_userbandnum].stop * 32;
        } else {
            if(mode_3k != 0) {
                q = 3;
            } else {
                q = 5;
            }
            start = ambands[band].start / q;
            stop  = ambands[band].end / q;
        }
    } else {
        band = akc6955_get_fmband();
        if(band == AKC6955_BAND_FMUSER){
            start = userband.fm_usrbands[setup.fm_userbandnum].start * 32;
            stop = userband.fm_usrbands[setup.fm_userbandnum].stop * 32;
        } else {
            start = ((fmbands[band].start - 3000) * 2) / 5;
            stop = ((fmbands[band].end - 3000) * 2) / 5;;
        }
    }
    if(i > stop) i = stop; // ADD
    if(i < start) i = start;

    b.byte = i & 0xff;
    akc6955_writecmd(AKC6955_CH_LO, b.byte);

    b.byte = i >> 8;
    b.b6 = 1;
    if(mode_3k != 0){
        b.b5 = 1; // Mode 3K ON
    }
    akc6955_writecmd(AKC6955_CH_HI, b.byte);

    akc6955_do_tune();
}

void akc6955_do_scan(unsigned char up)
{
    __bitops_t b;
    unsigned char c;

    //20130823 Need wait for scan/tune completed w/o SDCC 3.3.x.
#ifndef __SDCC
    while(akc6955_chk_donescan() == 0)
    {
        if(pollkey_single_timeout(1, 0) == charcode_a) return;  // 23ms, if 'A' Abort.
    }
#endif
    b.byte = akc6955_readcmd(AKC6955_POWER) & 0b11000111;

//    b.b3 = 0;
 //   b.b4 = 0;
// 20130823 : Is this collect?
#ifdef __SDCC
//     b.b5 = 0;
    akc6955_writecmd(AKC6955_POWER, b.byte);
    idle_time_35ms();
#endif

    b.b5 = 1; // Tune 0->1.
    akc6955_writecmd(AKC6955_POWER, b.byte);
    idle_time_35ms();

    b.b4 = 1;
    if(up != 0) {
        b.b3= 1;
    }
    akc6955_writecmd(AKC6955_POWER, b.byte); // Raise seek bit to '1'.
    idle_time_35ms();
}

void akc6955_abort_scan(void)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_POWER);
    b.b4 = 0;
    akc6955_writecmd(AKC6955_POWER, b.byte); // Falldown seek bit to '0'.
}

void akc6955_set_scanrate_fm(unsigned char rate)
{
    unsigned char c;
    c = akc6955_readcmd(AKC6955_SPACE);
    c = (c & 0xcf) | ((rate & 0x03) << 4);
    akc6955_writecmd(AKC6955_SPACE, c);
}

unsigned char akc6955_get_scanrate_fm(void)
{
//    unsigned char c;
//    c = akc6955_readcmd(AKC6955_SPACE);
//    c = (c & 0x30) >> 4;
   return (akc6955_readcmd(AKC6955_SPACE) & 0x30) >> 4;
}

unsigned char akc6955_chk_donescan(void)
{
    __bitops_t b;
    b.byte = akc6955_readcmd(AKC6955_RCH_HI);
    if(b.b6){
        return 0xff;
    }
    return 0;
}

unsigned int akc6955_get_channel(void)
{
    unsigned char h, l;
    unsigned int u;
    l = akc6955_readcmd(AKC6955_RCH_LO) ;
    h = akc6955_readcmd(AKC6955_RCH_HI) & 0x1f;
    return  (h << 8) | l;
//    return u;
}

/*
 * Get AM/FM Frequency: ret = KHz at AM, 10KHz @FM.
 */
unsigned int akc6955_get_freq(void)
{
    __bitops_t b;
    unsigned int i;
    unsigned int freq;
    unsigned char band;
    unsigned char q;
    unsigned char f;

    f = akc6955_get_fm();
    i = akc6955_get_channel();
    if(f != 0){ // 25KHz
        freq = i * 2 + i / 2 + 3000; // freq' = 25*i[KHz] = (25 / 10) *i [10KHz]
    } else { // 5K
       b.byte = akc6955_readcmd(AKC6955_CH_HI);
       band = akc6955_get_amband();
       if((band == AKC6955_BAND_MW2) || (band == AKC6955_BAND_LW) || (b.b5)){
           q = 3;
       } else {
           q = 5;
       }
       freq = i * q;
    }
    return freq;
}

void akc6955_set_freq(unsigned int freq)
{
    unsigned int ch;
    __bitops_t mode3k;
    unsigned char band;
    unsigned char q;
    unsigned char f;

    f = akc6955_get_fm();
    if(f != 0) { // FM
       band = akc6955_get_fmband();
       //        band &= 7;
       ch = ((freq - 3000) * 2) / 5;
    } else {
        band = akc6955_get_amband();
        mode3k.byte = akc6955_readcmd(AKC6955_CNR_AM);
        if((band == AKC6955_BAND_MW2) || (band == AKC6955_BAND_LW) || (mode3k.b7)){
            q = 3;
            mode3k.b7 = 1;
        } else {
            q = 5;
            mode3k.b7 = 0;
        }
        ch = freq / q;
    }
    akc6955_set_tune(mode3k.b7, ch);
}

void akc6955_set_userband(unsigned char start, unsigned char stop, unsigned int ch, unsigned char mode3k)
{
    unsigned char f;

    f = akc6955_get_fm();
    akc6955_writecmd(AKC6955_UCH_ST, start);
    akc6955_writecmd(AKC6955_UCH_EN, stop);
    if(f != 0){
        akc6955_set_fmband(AKC6955_BAND_FMUSER);
    } else {
        akc6955_set_amband(AKC6955_BAND_AMUSER);
    }
    akc6955_set_tune(mode3k, ch);
}


unsigned char akc6955_get_cnr(void)
{
    unsigned char f;
    __bitops_t b;
    f = akc6955_get_fm();
    if(f != 0) { // FM
        b.byte = akc6955_readcmd(AKC6955_CNR_FM);
    } else { // AM
        b.byte = akc6955_readcmd(AKC6955_CNR_AM);
    }
    b.b7 = 0;
    return b.byte;
}

int akc6955_read_level(void)
{
    unsigned char f;
    unsigned char rflevel, iflevel;
    unsigned char b;
    int rssi;
    unsigned char band;
    int totallevel;
    int level;

    f = akc6955_get_fm();
    b =  akc6955_readcmd(AKC6955_PGALEVEL);
    rflevel = (b & 0xe0) >> 5;
    iflevel = (b & 0x1c) >> 2;
    totallevel = rflevel + iflevel;

    rssi = (int)(akc6955_readcmd(AKC6955_RSSI) & 0x7f);
    level = (int)(totallevel * 6 + rssi);
    if(f != 0){
        level = 103 - level; // totallevel * 6
    } else {
        band = akc6955_get_amband();
        if((band >= AKC6955_BAND_SW1) && (band <= AKC6955_BAND_AMUSER)) { // SW
            level = 103 - level;
        } else { //  MW,LW
            level = 123 - level;
        }
    }
    return level;
}


// Get diff. unit = 100Hz.
int akc6955_get_diff(void)
{
    __bitops_t diff;
    unsigned char f;
    int n;

    diff.byte = akc6955_readcmd(AKC6955_FDNUM);
    if(diff.b7) {
        diff.b7 = 0;
        n = -((int) diff.byte);
    } else {
        diff.b7 = 0;
        n = (int)diff.byte;
    }

    f = akc6955_get_fm();
    if(f != 0) { // FM
        return n * 10;
    }
    return n; // 10n
}

void akc6955_up_freq(unsigned int step)
{
    unsigned int freq;
//    __bitops_t mode3k;
    unsigned char mode3k;

    freq = akc6955_get_channel();
    freq += step;
//    mode3k.byte = akc6955_readcmd(AKC6955_CNR_AM);
//    akc6955_set_tune(mode3k.b7, freq);
    mode3k = akc6955_get_mode3k();
    akc6955_set_tune(mode3k, freq);
}


void akc6955_down_freq(unsigned int step)
{
    unsigned int freq;
    unsigned char mode3k;

    freq = akc6955_get_channel();
    if(freq <= step) return;
    freq -= step;
//    mode3k.byte = akc6955_readcmd(AKC6955_CNR_AM);
    mode3k = akc6955_get_mode3k();
    akc6955_set_tune(mode3k, freq);
}

void akc6955_setvolumemode(unsigned char flag)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_ENABLE);
    c.b3 = 0;
    if(flag != 0x00){
        c.b3 = 1;
    }
    akc6955_writecmd(AKC6955_ENABLE, c.byte);
}

unsigned char akc6955_getvolumemode(void)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_ENABLE);
    if(c.b3){
        return 0xff;
    }
    return 0;
}

void akc6955_setvolume(unsigned char level)
{
//    unsigned char c;
//    c = akc6955_readcmd(AKC6955_VOLUME) & 0x03;
    if(level > 63) level = 63;
    akc6955_writecmd(AKC6955_VOLUME, ((akc6955_readcmd(AKC6955_VOLUME) & 0x03) | (level << 2)));
}

unsigned char akc6955_getvolume(void)
{
    unsigned char c;
    c = akc6955_readcmd(AKC6955_VOLUME) >> 2;
    return c;
}

void akc6955_set_prevolume(unsigned char level)
{
    unsigned char c;
    c = akc6955_readcmd(AKC6955_PRE) & 0xf3;
    c |= ((level & 0x03) << 2);
    akc6955_writecmd(AKC6955_PRE, c);
}

unsigned char akc6955_get_prevolume(void)
{
    unsigned char c;
//    c = akc6955_readcmd(AKC6955_PRE) & 0x0c;
 //   c >>= 2;
    return (akc6955_readcmd(AKC6955_PRE) & 0x0c) >> 2;
}


void akc6955_setphase(unsigned char flag)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_VOLUME);

    c.b0 = 1;
    if(flag == 0) {
        c.b0 = 0; //
    }
    akc6955_writecmd(AKC6955_VOLUME, c.byte);
}

void akc6955_setline(unsigned char flag)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_VOLUME);
    c.b1 = 1;
    if(flag == 0) {
        c.b1 = 0;
    }
    akc6955_writecmd(AKC6955_VOLUME, c.byte);
}

void akc6955_set_lowboost(unsigned char flag)
{
    __bitops_t c;
    c.byte = akc6955_readcmd(AKC6955_STEREO);
    c.b3 = 1;
    if(flag == 0) {
        c.b3 = 0;
    }
    akc6955_writecmd(AKC6955_STEREO, c.byte);
}

void akc6955_set_stereomode(unsigned char mode)
{
    unsigned char c;
    c = akc6955_readcmd(AKC6955_STEREO);
    mode = (mode & 0x03) << 2;
    c = (c & 0xf3) | mode;
    akc6955_writecmd(AKC6955_STEREO, c);
}

unsigned char akc6955_get_stereo(void)
{
 //   unsigned char c;
//    c = akc6955_readcmd(AKC6955_RCH_HI) & 0x80;
    return akc6955_readcmd(AKC6955_RCH_HI) & 0x80;
}

/*
 * Get battery level.
 * Unit = 0.01V
 */

unsigned int akc6955_get_battery(void)
{
    unsigned int batt;
    unsigned char c;
    c = akc6955_readcmd(AKC6955_VBAT) & 0x3f;
    batt = 180 + c * 5;
    return batt;
}

/*
 * Misc
 */
void akc6955_set_fmbandwidth(unsigned char bw)
{
   unsigned char c = akc6955_readcmd(AKC6955_STEREO);
   c = (c & 0xfc) | (bw & 0x03);
   akc6955_writecmd(AKC6955_STEREO, c);
}

unsigned char akc6955_get_fmbandwidth(void)
{
    return (akc6955_readcmd(AKC6955_STEREO) & 0x03);
}



void akc6955_set_thresh_fmstereo(unsigned char a)
{
    unsigned char b;
    a = a & 0x03;
    setup.threshold_fmstereo = a;
    b = akc6955_readcmd(AKC6955_THRESH) & 0xfc;
    akc6955_writecmd(AKC6955_THRESH, a | b);
}

void akc6955_set_thresh_width(unsigned char a)
{
    unsigned char b;
    a = a & 0x03;
    setup.threshold_width = a;
    a = a << 2; // << 2
    b = akc6955_readcmd(AKC6955_THRESH) & 0xf3;;
    akc6955_writecmd(AKC6955_THRESH, a | b);
}

void akc6955_set_thresh_amcnr(unsigned char a)
{
    unsigned char b;
    a = a & 0x03;
    setup.threshold_amcnr = a;
    a = a << 4; // << 4
    b = akc6955_readcmd(AKC6955_THRESH) & 0xcf;
    akc6955_writecmd(AKC6955_THRESH, a | b);
}

void akc6955_set_thresh_fmcnr(unsigned char a)
{
    unsigned char b;
    a = a & 0x03;
    setup.threshold_fmcnr = a;
    a = a << 6; // << 4
    b = akc6955_readcmd(AKC6955_THRESH) & 0x3f;
    akc6955_writecmd(AKC6955_THRESH, a | b);
}
