/*
 * OpenI2CRADIO
 * Backlight Handler
 * Copyright (C) 2013-08-31 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "backlight.h"
#include "idle.h"
#include "menu.h"
#include "power.h"

int backlight_counter;
unsigned char l_backlight_level;

void lcd_setbacklight(unsigned char flag, unsigned char level)
{
    __bitops_t  b;
    __bitops_t d;
   l_backlight_level = level;
   if(flag == 0) {
        d.byte = _LCD_BACKLIGHT_TRIS;
        d._LCD_BACKLIGHT_BIT = 1;
        _LCD_BACKLIGHT_TRIS = d.byte;
        PSTRCONbits.STRA = 0;
        T2CONbits.TMR2ON = 0;
        TMR2 = 0x00;
        CCP2CON = 0x00;
        CCPR2L = 0;
        CCPR2H = 0;
    } else {
      unsigned char h,l;
      h = level >> 1;
      if(h == CCPR1L) return;
 //     l = 2 << 4; //(lv & 0x0300) >> 4;
      d.byte = _LCD_BACKLIGHT_TRIS;
      d._LCD_BACKLIGHT_BIT = 1;
      _LCD_BACKLIGHT_TRIS = d.byte;
      //PSTRCON = 0;
      CCPR2L = h;
      CCPR2H = h;
      b.b2 = 1;
      b.b3 = 1;
      CCP2CON = b.byte;
      PR2 = 50;
      PIR1bits.TMR2IF = 0;
      T2CON = 0b01111000; // Pre-scaler=1/1,Post-scaler = 1/16
      // -> Freq = 2.44KHz * 16 = 39.4KHz.
      TMR2 = 0x00;
      T2CONbits.TMR2ON = 1;
      do {
          idle_time_ms(2); // 
      } while(PIR1bits.TMR2IF == 0);
      d.byte = _LCD_BACKLIGHT_TRIS;
      d._LCD_BACKLIGHT_BIT = 0;
      _LCD_BACKLIGHT_TRIS = d.byte;

//      _LCD_PORT |= _LCD_BACKLIGHT;
    }
}

void backlight_reset(unsigned char ctlword)
{
    if(ctlword == charcode_e){
        if(backlight_counter != 0){
           backlight_counter = 0;
           lcd_setbacklight(0x00, 0); // Turn OFF
        } else {
           backlight_counter = setup.backlight_long;
           lcd_setbacklight(0xff, setup.backlight_level); // Turn ON
        }
        return;
    }
   if((ctlword >= charcode_1) && (ctlword <= charcode_f)) {
            backlight_counter = setup.backlight_long;
            lcd_setbacklight(0xff, setup.backlight_level); // Turn ON
    }
}


unsigned char backlight_dec(unsigned char dispf)
{
    unsigned char pbutton;
    unsigned char stat = dispf;

    pbutton = chk_powerbutton(); // 48ms
    if(pbutton != 0) shutdown(1); // Button pressed.
    ClrWdt();

       if(backlight_counter > 0) {
          if(dispf == 0) {
              acm1602_resume(LCD_I2CADDR);
               stat = 0xff;
	       lcd_setbacklight(0xff, setup.backlight_level);
	  }

           backlight_counter--;
           //lcd_setbacklight(0xff, setup.backlight_level); // Turn ON
       } else {
           lcd_setbacklight(0x00, 0); // Turn OFF
           acm1602_suspend(LCD_I2CADDR);
           stat = 0;
        }
    return stat;
}