/*
 * OpenI2CRADIO
 * EUSART Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef EUART_H
#define	EUART_H

#ifdef	__cplusplus
extern "C" {
#endif

#define UART_BUF_SIZE 256
#define UART_CH_XOFF 19
#define UART_CH_XON 17
#define UART_FRAMEERROR 0x01
#define UART_OVERFLOW 0x02
#define UART_TIMEOUT 0x04
#define UART_WAKEUP 0x80
#define UART_RTSIN PORTDbits.RD3
#define UART_CTSOUT PORTCbits.RC5
   
extern void uart_sleep(void);
extern void uart_wakeup(void);
extern void uart_init(void);
extern void uart_inthdr_rx(void);
extern unsigned char uart_pullchar(void);
extern unsigned char uart_pushchar(unsigned char c, unsigned int timeout);
extern void uart_pushxon(unsigned int timeout);
extern void uart_pushxoff(unsigned int timeout);
extern void uart_break(void);
extern unsigned char uart_getstat(void);

#ifdef	__cplusplus
}
#endif

#endif	/* EUART_H */

