/*
 * OpenI2CRADIO
 * String utls
 * Copyright (C) 2013-11-07 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "shell_strutl.h"
#include "euart.h"
#include "uart_termio.h"

void bin2hex(char *s, unsigned char v)
{
    unsigned char c;
    c = v >> 4;
    if(c > 9) {
        c = c - 10 + 'A';
    } else {
        c = c + '0';
    }
    s[0] = c;

    c = v & 0x0f;
    if(c > 9) {
        c = c - 10 + 'A';
    } else {
        c = c + '0';
    }
    s[1] = c;
    s[2] = 0x00;
}
unsigned char c2h(unsigned char c)
{
    if(c < '0') return 0xff;
    if(c > 'F') return 0xff;
    if(c <= '9') return c - '0';
    if(c >= 'A') return c - 'A' + 10;
    return 0xff;
}

unsigned char hex2byte(unsigned char *p)
{
    unsigned char h, l;
    h = c2h(p[0]);
    l = c2h(p[1]);
    if((h >= 0x10) || (l >= 0x10)) return 0;
    return (h << 4) | l;
}

unsigned char check_eol(unsigned char *p)
{
    unsigned char i;
    unsigned char c;
    for(i = 0; i < 2; i++){
        c = p[i];
        switch(c){
            case '\0':
            case '\n':
            case '\r':
                return 0xff;
                break;
            default:
                break;
        }
//        if(c < '0') return 0xff;
//        if(c > 'F') return 0xff;
    }
    return 0;
}

unsigned char migrate_hex(unsigned char *p)
{
    unsigned char i;
    unsigned char c;
    for(i = 0; i < 2; i++){
        c = p[i];
        if(c < '0') return 0;
        if(c > 'F') return 0;
        if((c > '9') && (c < 'A')) return 0;
    }
    return 0xff;
}

int  search_head_s(unsigned char *s)
{
   int i;
   for(i = 0; i < 127; i++) {
      switch(s[i]) {
       case 'S':
	 return i;
	 break;
       case '\0':
	 return -1; // Not found 'S' until eoln.
	 break;
       default:
	 break;
      }
   }
   return -1; // Error
}

/*
 * Saving or Loading use MOTOROLLA S FORMAT with 24bit address.
 * See details:
 * http://www.geocities.jp/chako_ratta/micon/s_format.html (written in Japanese)
 * 
 */
int str_shexheader(unsigned char *s, unsigned char *file)
{
    unsigned char pp;
    unsigned char sum;
    unsigned char c;
    unsigned char bytes;
    unsigned int i;
    unsigned char sbuf[4];
//    if(check_eol(s) != 0) return TERM_NULL;

    if((s[0] != 'S') || (s[1] != '0')) return TERM_NONSREC;
    uart_term_putstr("\nHEAD");
    if(migrate_hex(&s[2])  == 0) return TERM_NONSREC;
    bytes = hex2byte(&s[2]);
    if(bytes <= 2) return TERM_SRECERR;
    for(i = 4; i < 8; i++) if(s[i] != '0') return TERM_NONHDR;
    sum = bytes;
    bytes -= 3;
    pp = 0;
    while(bytes > 0) {
        if(migrate_hex(&s[i]) == 0) return TERM_SRECERR;
        c = hex2byte(&s[i]);
        sum += c;
        file[pp] = c;
        i += 2;
        pp++;
        bytes--;
    }
    file[pp] = '\0';
    if(migrate_hex(&s[i]) == 0) return TERM_SRECERR;
    c = hex2byte(&s[i]);
    sum = ~sum;
    bin2hex(sbuf, sum);
    uart_term_putstr(sbuf);

    if(c != sum) return TERM_SUMERR;
    uart_term_putstr("...OK\n");
    return TERM_OK;
}


/*
 * 'S1' record to hex
 * Accept only S2 and S8.
 */
int str_shex2bin(unsigned char *s, unsigned char *p, unsigned long *addr, unsigned char *len)
{
    unsigned char sum = 0;
    unsigned char pp;
    unsigned int i;
    unsigned char bytes;
    unsigned char h, l, l2;
    unsigned char c;
    // Get Header
    if(s[0] != 'S')  return TERM_NONSREC;
    if(s[1] == '2') { //  Data core
        for(i = 2; i < 10; i += 2) if(migrate_hex(&s[i]) == 0) return TERM_SRECERR;
        bytes = hex2byte(&s[2]);
        if(bytes <= 3) return TERM_SRECERR;
        sum = bytes;
        h = hex2byte(&s[4]);
        l  = hex2byte(&s[6]);
        l2  = hex2byte(&s[8]);
        *addr = (h * 65536) | (l << 8) | l2;
        sum = sum + h + l + l2;
        bytes -= 3;
        *len = bytes - 1;
        pp = 0;
        i = 10;
        while(bytes > 1) {
            if(migrate_hex(&s[i]) == 0) return TERM_SRECERR;
            c = hex2byte(&s[i]);
            sum += c;
            p[pp] = c;
            i += 2;
            pp++;
            bytes--;
        }
        if(migrate_hex(&s[i]) == 0) return TERM_SUMERR;
        c = hex2byte(&s[i]);
        sum = ~sum;
        if(c != sum) return TERM_SUMERR;
        /*
         * OK!
         */
    } else if(s[1] == '8') {
        if((s[2] != '0') || (s[3] != '4')) return TERM_SRECERR;
        uart_term_putstr("TAIL");
        for(i = 4; i < 10; i += 2)  if(migrate_hex(&s[i]) == 0) return TERM_SRECERR;
        sum = 4;
        h = hex2byte(&s[4]);
        l = hex2byte(&s[6]);
        l2 = hex2byte(&s[8]);
        c = hex2byte(&s[10]);
//        *addr = (h * 65536) | (l << 8) | l2;
        *len = 0;
        sum = ~(sum + h + l + l2);
        if(c != sum) return TERM_SUMERR;
        uart_term_putstr(" OK.");
        return TERM_SRECEND;
    } else {
        return TERM_UNDSREC;
    }
    return TERM_OK;
}


/*
 * Set "S1" Record
 */
unsigned char str_bin2hex(unsigned char *s, unsigned char *p, unsigned long addr, unsigned char len)
{
    unsigned int pp;
    unsigned char pv;
    unsigned char sum;
    unsigned char i;
    unsigned char c;
    s[0] = 'S';
    s[1] = '2';
    if(len > 254) len = 254;
    i = len + 4; //HEX
    sum = i;
    bin2hex(&s[2], i);

    c = (addr >> 16) & 255;
    sum += c;
    bin2hex(&s[4], c);

    c = (addr >> 8) & 255;
    sum += c;
    bin2hex(&s[6], c);

    c = addr  & 255;
    sum += c;
    bin2hex(&s[8], c);

    pp = 10;
    for(pv = 0; pv < len ; pv++){
        c = p[pv];
        sum += c;
        bin2hex(&s[pp], c);
        pp += 2;
    }
    sum = ~sum;
    bin2hex(&s[pp], sum);
    pp += 2;
    s[pp] = '\n';
    s[pp + 1] = '\0';
    return len;
}

unsigned char str_put_shexheader(unsigned char *s, char *filename)
{
    unsigned int i;
    unsigned char pp;
    unsigned char len;
    unsigned char sum;
    s[0] = 'S';
    s[1] = '0';
    len = shell_strlen(filename);
    if(len > 252) len = 252;
    sum = len + 3;
    bin2hex(&s[2], len + 3);

    for(i = 4; i < 8; i++) s[i] = '0';
    i = 8;
    pp = 0;
    while(pp != len){
        bin2hex(&s[i], filename[pp]);
        sum += filename[pp];
        i += 2;
        pp++;
    }
    sum = ~sum;
    bin2hex(&s[i], sum);
    s[i + 2] = '\n';
    s[i + 3] = '\0';
    return len;
}

unsigned char str_put_shexfooter(unsigned char *s)
{
    unsigned int i;
    unsigned char pp;
    unsigned char sum;
    s[0] = 'S';
    s[1] = '8';
    s[2] = '0';
    s[3] = '4';
    sum = 4;
    for(pp = 4; pp < 10; pp++) s[pp] = '0';
    sum = ~sum;
    bin2hex(&s[pp], sum);

    s[pp + 2] = '\n';
    s[pp + 3] = '\0';
    return 0;
}


unsigned char shell_strlen(char *s)
{
    unsigned char i = 0;
    while(i < 255) {
        if(s[i] == '\0') break;
        i++;
    }
    return i;
}

unsigned char shell_gettok(char *dst, char *src)
{
    unsigned char i;
    char c;
    i = 0;
    while(1) {
        c = src[i];
        if(c == '\0') break;
        if(c == ' ') break;
        if(c == '\t') break;
        if(c == '\n') break;
        dst[i] = c;
        i++;
        if(i > 126) break;
    }
    dst[i] = '\0';
    return i;
}

int shell_strcmp(char *from, char *to)
{
    unsigned char f, t;
    unsigned char i;
    int p = 0;

    while(from[p] != '\0'){
        if(from[p] != to[p]) return -1;
        p++;
    }
    return p;
}

long term_getuint(char *pool)
{
    long i = 0;
    unsigned char p = 0;
    unsigned char c;

    do {
        c = pool[p];
        if(c == '\0') break;
        if(c == '\n') break;
        if(c == '\t') break;
        if(c == ' ') break;
        if((c < '0') || (c > '9')) return -1;
        i *= 10;
        i = i + (c - '0');
        p++;
    } while(p <= 10);

    return i;
}

void term_printnum(char *pool, unsigned int num)
{
    char p[5];
    int j;
    int i, ii;

    for(i = 0; i < 5; i++){
        p[i] = num % 10;
        num = num / 10;
    }
    i = 4;
    do {
        if(p[i] != 0) break;
        i--;
    } while(i >= 0);
   
    if(i < 0){
        pool[0] = '0';
        pool[1] = '\0';
        return;
    }
    ii = i;
    for(j = 0; j <= ii; j++) {
        pool[j] = p[i] + '0';
        i--;
    }
    pool[j] = '\0';
    return;
}
