/*
 * OpenI2CRADIO
 * String utls header.
 * Copyright (C) 2013-11-07 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef SHELL_STRUTL_H
#define	SHELL_STRUTL_H

#ifdef	__cplusplus
extern "C" {
#endif

#define TERM_OK 0
#define TERM_NONSREC -1
#define TERM_STRERR -2
#define TERM_SUMERR -3
#define TERM_SRECERR -4
#define TERM_UNDSREC -5
#define TERM_SRECEND -15
#define TERM_NULL -16
#define TERM_NONHDR -17

extern void bin2hex(char *s, unsigned char v);

extern unsigned char hex2byte(unsigned char *p);
extern unsigned char check_eol(unsigned char *p);
extern unsigned char c2h(unsigned char c);
extern unsigned char migrate_hex(unsigned char *p);
extern int search_head_s(unsigned char *s);
extern int str_shexheader(unsigned char *s, unsigned char *file);
extern int str_shex2bin(unsigned char *s, unsigned char *p, unsigned long *addr, unsigned char *len);

extern unsigned char str_put_shexheader(unsigned char *s, char *filename);
extern unsigned char str_bin2hex(unsigned char *s, unsigned char *p, unsigned long addr, unsigned char len);
extern unsigned char str_put_shexfooter(unsigned char *s);

extern unsigned char shell_strlen(char *s);
extern unsigned char shell_gettok(char *dst, char *src);
extern int shell_strcmp(char *from, char *to);

extern long term_getuint(char *pool);
extern void term_printnum(char *pool, unsigned int num);


#ifdef	__cplusplus
}
#endif

#endif	/* SHELL_STRUTL_H */

