	
X.Dom = X.Class._override(
	new X.EventDispatcher(),
	{
		readyState   : -1,
		active       : !!document.activeElement,
		_root        : null,

		_lock        : false,
		w            : 0,
		h            : 0,
		baseFontSize : 0,

/* -----------------------------------------------
 * Resize
 *  original : uupaa.js
 * 
 * TODO
 *  https://w3g.jp/blog/studies/ios7_1_minimal-ui_warning
 *  iOS7.0からあったiPad Safariの高さ100%コンテンツでlandscape（横向き）時に起きる不具合
 * 
 * getBoundingClientRect で　fontsize の調査
 */
		_resize :
			X.UA.IE && X.UA.IE < 9 ?
				(function(){
					var size;
					if( !X.Dom._lock ){
						size = X.Dom._getSize();
						if( X.Dom.w !== size[ 0 ] || X.Dom.h !== size[ 1 ] ){
							X.Dom.w = size[ 0 ];
							X.Dom.h = size[ 1 ];
							X.Timer.once( 100, X.Dom._detectFinishResizing );
							X.Dom._lock = true;
						};
					};
					
					size = Node._fontSizeNode._rawNode.offsetHeight;
					if( X.Dom.baseFontSize !== size ){
						X.Dom.baseFontSize && X.Dom.asyncDispatch( 0, { type : X.Dom.Event.BASE_FONT_RESIZED, size : size } );
						X.Dom.baseFontSize = size;
					};
					
				}) :
				(function( e ){
					!X.Dom._lock && ( X.Dom._lock = true ) && X.Timer.once( 100, X.Dom._detectFinishResizing );
					return X.Callback.PREVENT_DEFAULT | X.Callback.STOP_PROPAGATION;
				}),
		
		_detectFinishResizing : function (){
			var size = X.Dom._getSize();
			if( X.Dom.w !== size[ 0 ] || X.Dom.h !== size[ 1 ] ){
				X.Dom.w = size[ 0 ];
				X.Dom.h = size[ 1 ];
				X.Timer.once( 100, X.Dom._detectFinishResizing );
			} else {
				X.Dom.asyncDispatch( 0, { type : X.Dom.Event.VIEW_RESIZED, w : X.Dom.w, h : X.Dom.h } );
				X.Dom._lock = false;
			};
		},

		_init : function(){
			var s, size, h, r;
			if( X.Dom.Event.DOM_PRE_INIT <= X.Dom.readyState ) return X.Callback.UN_LISTEN;
			if( s = X.Dom._script ){
				s.parentNode.removeChild( s );
				s.onreadystatechange = X.emptyFunction;
				s.onreadystatechange = null;
				delete X.Dom._script;
			};
			delete X.Dom._init;
			X.Dom.readyState = X.Dom.Event.DOM_PRE_INIT;
			
			/* if( X.UA.IE ) */
			X.Dom._root = ( document.compatMode !== 'CSS1Compat' ? document.body : document.documentElement );

			h = Node._html = document.documentElement ?
					new Node( document.documentElement ) :
				X.Dom.DOM_W3C ?
					new Node( document.getElementsByTagName( 'html' )[ 0 ] ) :
				X.Dom.DOM_IE4 ?
					new Node( document.all.tags( 'html' )[ 0 ] ) :
					null;
		
			r = Node.root = new Node( document.body );
			h.appendTo = h.appendToRoot = h.before = h.after = h.clone = h.remove = h.destroy = h.prevNode = h.nextNode = h.createText = h.append = h.appendAt = h.empty = h.html = h.text =
			r.appendTo = r.appendToRoot = r.before = r.after = r.clone = r.remove = r.destroy = r.prevNode = r.nextNode = new Function( 'return this' );
			
			r._root  = h._root = r;
			r.parent = h;
			h._xnodes = [ r ];

			X.Dom.listenOnce( X.Dom.Event.DOM_PRE_INIT, function(){
				X.Dom.readyState = X.Dom.Event.DOM_BUILDER_COMPLETE;
				!X.Dom._useBuilder && X.Dom.asyncDispatch( 0, { type : X.Dom.Event.DOM_BUILDER_COMPLETE } );
			} );
			
			X.Dom.listenOnce( X.Dom.Event.DOM_BUILDER_COMPLETE, function(){
				X.Dom.readyState = X.Dom.Event.DOM_INIT;
				
				Node.root.appendAt( 0,
					Node._systemNode = Node.create( 'div', { 'class' : 'hidden-system-node' } ),
					Node._fontSizeNode = Node.create( 'div', { 'class' : 'hidden-system-node' } ).cssText( 'line-height:1;height:1em;' ).text( 'X' )
				)._startUpdate();

				X.Dom.asyncDispatch( 0, { type : X.Dom.Event.DOM_INIT } );
			} );

			X.Dom.listenOnce( X.Dom.Event.DOM_INIT, function(){
				var size = X.Dom._getSize();

				if( X.Dom._detectFontSize ){
					X.Dom.Node._window.listen( 'resize', X.Dom._resize );
					X.Timer.add( 333, X.Dom._detectFontSize );
				} else {
					X.Timer.add( 333, X.Dom._resize );
				};
				
				X.Dom.baseFontSize = Node._fontSizeNode._rawNode.offsetHeight;
				
				X.Dom.readyState = X.Dom.Event.XDOM_READY;
				X.Dom.asyncDispatch( 0, { type : X.Dom.Event.XDOM_READY, w : X.Dom.w = size[ 0 ], h : X.Dom.h = size[ 1 ] } );
			} );

			X.Dom.asyncDispatch( 0, { type : X.Dom.Event.DOM_PRE_INIT } );	

			Node._window
				.listen( 'beforeunload', X.Dom )
				.listenOnce( 'unload', X.Dom );

//ブラウザの戻るボタンで戻ったときに呼ばれるイベントとかキャッシュとかそこらへんのこと
//http://d.hatena.ne.jp/koumiya/20080916/1221580149

			if( document[ 'hidden' ] !== undefined ) {// iOS 7+
				Node._document.listen( 'visibilitychange', X.Dom );
			} else
			if( document[ 'webkitHidden' ] !== undefined ) {
				Node._document.listen( 'webkitvisibilitychange', X.Dom );
			} else
			if( X.UA.iOS && window[ 'onpageshow' ] !== undefined ) {
				Node._window.listen('pageshow', X.Dom );
				Node._window.listen('pagehide', X.Dom );
			} else {
				Node._window.listen('focus', X.Dom );
				Node._window.listen('blur', X.Dom );
			};

			return X.Callback.UN_LISTEN;
		},

		handleEvent : function( e ){
			var href;
			switch( e.type ){
				case 'beforeunload' :
					
					// ie では　a href="javascript" な要素でも beforeunload が起こる
					href = e.target && e.target.attr( 'href' );
					if( href && href.indexOf && href.indexOf( 'javascript:' ) === 0 ) return X.Callback.PREVENT_DEFAULT | X.Callback.STOP_PROPAGATION;
					
					return X.Dom.dispatch( { type : X.Dom.Event.BEFORE_UNLOAD } );
				case 'unload' :
					X.Dom.dispatch( { type : X.Dom.Event.UNLOAD } );
					
					Node._window.unlisten();
					Node._document.unlisten();
					Node._html._actualRemove( true );
					break;
				case 'visibilitychange' :
					X.Dom.dispatch( { type : ( X.Dom.activate = document[ 'hidden' ] ) ? X.Dom.Event.VIEW_DEACTIVATE : X.Dom.Event.VIEW_ACTIVATE } );
					break;
				case 'webkitvisibilitychange' :
					X.Dom.dispatch( { type : ( X.Dom.activate = document[ 'webkitHidden' ] ) ? X.Dom.Event.VIEW_DEACTIVATE : X.Dom.Event.VIEW_ACTIVATE } );
					break;
				case 'pageshow' :
				case 'focus' :
					X.Dom.activate = true;
					X.Dom.dispatch( { type : X.Dom.Event.VIEW_ACTIVATE } );
					break;
				case 'pagehide' :
				case 'blur' :
					X.Dom.activate = false;
					X.Dom.dispatch( { type : X.Dom.Event.VIEW_DEACTIVATE } );
					break;
			};
		},

		listen : function( type ){
			if( type <= X.Dom.readyState ){
				/*
				 * X.Dom.Event.XDOM_READY 以後に listen した場合の対策
				 */
				X.Dom.asyncDispatch( 0, { type : type, w : X.Dom.w, h : X.Dom.h } );
			};
			return X.EventDispatcher.prototype.listen.apply( X.Dom, arguments );
		},
		
		getPointerPosition : function(){
			
		},
		
		/* 要素が視界に入った  http://remysharp.com/2009/01/26/element-in-view-event-plugin/ */
		inView : function( elm ){
			
		},

		_getSize :
			X.UA.IE ?
				new Function( 'return[X.Dom._root.clientWidth,X.Dom._root.clientHeight]' ) :
				new Function( 'return[window.innerWidth,window.innerHeight]' ),
		
		getSize : function(){
			return [ X.Dom.w, X.Dom.h ];
		},
//https://developer.mozilla.org/en-US/docs/Web/API/Element.getBoundingClientRect
//use window.pageXOffset and window.pageYOffset instead of window.scrollX and window.scrollY
//(((t = document.documentElement) || (t = document.body.parentNode)) && typeof t.ScrollLeft == 'number' ? t : document.body).ScrollLeft;
//(((t = document.documentElement) || (t = document.body.parentNode)) && typeof t.ScrollTop == 'number' ? t : document.body).ScrollTop
		
		getDocumentSize : function(){
			// Opera は互換モードでは document.body.scrollHeight、標準モードでは document.documentElement.scrollHeight でページの高さが取れる。と思ってたんだけど、例外があった。
			// http://orera.g.hatena.ne.jp/edvakf/20100515/1273908051
		//http://onozaty.hatenablog.com/entry/20060803/p1
		// Safari2.0.4では標準・互換どちらも document.body
			
			Node.root._updateTimerID && Node.root._startUpdate();
			
			return [
				X.Dom._root.scrollWidth  || X.Dom._root.offsetWidth,
				X.Dom._root.scrollHeight || X.Dom._root.offsetHeight
			];
		},
		
		getScrollPosition :
			window.pageXOffset !== undefined ?
				( function(){
					Node.root._updateTimerID && Node.root._startUpdate();
					return[ window.pageXOffset, window.pageYOffset ];
				} ) :
			window.scrollLeft  !== undefined ?
				( function(){
					Node.root._updateTimerID && Node.root._startUpdate();
					return[ window.scrollLeft, window.scrollTop ];
				} ) :
				( function(){
					Node.root._updateTimerID && Node.root._startUpdate();
					// body は Safari2-
					return[ X.Dom._root.scrollLeft || document.body.scrollLeft, X.Dom._root.scrollTop || document.body.scrollTop ];
				} ),

		getScrollbarSize : function(){
			return [ X.Dom.BoxModel.vScrollbarSize, X.Dom.BoxModel.hScrollbarSize ];	
		}		
	}
);

if( !X.UA.IE || 9 <= X.UA.IE ){
	X.Dom._detectFontSize = function(){
		var size = Node._fontSizeNode._rawNode.offsetHeight;
		if( X.Dom.baseFontSize !== size ){
			X.Dom.baseFontSize && X.Dom.asyncDispatch( 0, { type : X.Dom.Event.BASE_FONT_RESIZED, size : size } );
			X.Dom.baseFontSize = size;
		};
	};
};

if( document.getElementById && ( !X.UA.IEMobile || 5 <= X.UA.IE ) ){
	X.Dom.DOM_W3C = true;
	if( document.addEventListener ){
		X.Dom.EVENT_W3C = true;
	} else
	if( document.attachEvent ){
		X.Dom.EVENT_IE = true;
	} else {
		X.Dom.EVENT_DOM0 = true;
	};
} else
if( document.all ){
	X.Dom.DOM_IE4    = true;
	X.Dom.EVENT_DOM0 = true;
};

X.Dom.cleanupTagNames = {
		noscript : 1,
		noframes : 1,
		'!'      : 1,
		noembed  : 1,
		nolayer  : 1
	};
X.Dom.skipCleanupTagNames = 'pre,textarea,code,kbd,samp,xmp,plaintext,listing'.split( ',' );
		
X.Dom.cleanupWhiteSpace = function( text ){
	var _ = ' ', __ = '  ';
	text.indexOf( '\n\r' ) !== -1 && ( text = text.split( '\n\r' ).join( _ ) );
	text.indexOf( '\t' )   !== -1 && ( text = text.split( '\t' ).join( _ ) );
	text.indexOf( '\r' )   !== -1 && ( text = text.split( '\r' ).join( _ ) );
	text.indexOf( '\n' )   !== -1 && ( text = text.split( '\n' ).join( _ ) );
	text.indexOf( '\f' )   !== -1 && ( text = text.split( '\f' ).join( _ ) );
	text.indexOf( '\b' )   !== -1 && ( text = text.split( '\b' ).join( _ ) );
	while( text.indexOf( __ ) !== -1 ){
		text = text.split( __ ).join( _ );
	};
	return text;
};

X.Dom.whiteSpaceToTag = function( text ){
    if( text == null ) return '';
    return text.toString()
    	//.split( '\r\n\r\n' ).join( '<br>' )
    	//.split( '\n\r\n\r' ).join( '<br>' )
    	//.split( '\r\n' ).join( '<br>' )
    	.split( '\n\r' ).join( '<br>' )
    	.split( '\r' ).join( '<br>' )
    	.split( '\n' ).join( '<br>' )
    	.split( '\t' ).join( '&nbsp;&nbsp;&nbsp;&nbsp;' )
    	.split( '\f' ).join( '' )
    	.split( '\b' ).join( '' );
};

X.Dom.chrReferanceTo = function( str ){
    if( str == null ) return '';
    return str.toString()
    	.split( '&amp;' ).join( '&' )
    	.split( '&lt;' ).join( '<' )
    	.split( '&gt;' ).join( '>' )
    	.split( '&nbsp;' ).join( ' ' );
};

/*
 * original
 * AS3で相対パスを絶対パスに変換する
 * http://www.shin-go.net/motionlab/?p=449
 */
X.Dom.baseURL = ( function( parts ){
	var last = 1 < parts.length && parts[ parts.length - 1 ];
	if( last !== false && ( last === '' || //末尾が/で終わるとき
		last.indexOf( '.' ) !== -1 ) ){//末尾がファイル名で終わる時
		
		--parts.length;
	};
	return parts.join( '/' );
})( location.href.split( '?' )[ 0 ].split( '#' )[ 0 ].split( '/' ) );

X.Dom.getAbsolutePath = function( path ){
	var s  = '/',
		ss = '//',
		_ary, ary, i = 0;

	if( 'http:file'.indexOf( path.substr( 0, 4 ) ) !== -1 ) return path;
	
	_ary = X.Dom.baseURL.split( ss );
	ary  = _ary[ 1 ].split( s );

	if( path.charAt( 0 ) === s ) return [ _ary[ 0 ], ss, ary[ 0 ], path ].join( '' );
		
	if( path.substr( 0, 2 ) === './' ){
		path = path.substr( 2 );
	} else {
		while( path.substr( i, 3 ) === '../' ){
			--ary.length;
			i += 3;
		};
		if( i ) path = path.substr( i );
	};
	return [ _ary[ 0 ], ss, ary.join( s ), s, path ].join( '' );
};

