/**
 * use X.Callback
 * 
 * http://d.hatena.ne.jp/uupaa/20100430/1272561922
 * 
 */

if( window.addEventListener ){
	X.Dom.Event = function( e, xnode ){
		//this._event        = e;
		this.type          = X.Dom.Event.RenameTo[ e.type ] || e.type;
		
		//http://www.quirksmode.org/js/events_properties.html
		if( e.target ){
			this.target        = Node._getXNode( e.target.nodeType === 3 ? e.target.parentNode : e.target );// defeat Safari bug // xnode
		};
		if( e.relatedTarget ){
			this.relatedTarget = Node._getXNode( e.relatedTarget.nodeType === 3 ? e.relatedTarget.parentNode : e.relatedTarget ); // xnode
		};
		
		this.currentTarget = xnode; // xnode
		this.eventPhase    = e.eventPhase;
		
		this.clientX       = e.clientX;
		this.clientY       = e.clientY;
		//this.screenX       = e.screenX;
		//this.screenY       = e.screenY;
		this.pageX         = e.pageX;
		this.pageY         = e.pageY;
		this.offsetX       = e.offsetX || e.layerX;
		this.offsetY       = e.offsetY || e.layerY;
		
		this.keyCode       = e.keyCode;
		this.altKey        = e.altKey;
		this.ctrlKey       = e.ctrlKey;
		this.shiftKey      = e.shiftKey;
		
		// http://www.programming-magic.com/20090127231544/
		this.which         = e.which || ( e.button + 1 ); // 左:1, 中:2, 右:3
		
		// https://developer.mozilla.org/ja/docs/DOM/DOM_event_reference/mousewheel
		
		// TODO
		// https://w3g.jp/blog/tools/wheelevent_crossbrowser
		// ホイール系イベント2014年版クロスブラウザ
		if( e.wheelDeltaY !== undefined ){
			this.wheelDeltaX = e.wheelDeltaX / 12;
			this.wheelDeltaY = e.wheelDeltaY / 12;
		} else
		if( e.wheelDelta !== undefined ){
			this.wheelDeltaX = this.wheelDeltaY = e.wheelDelta / 12;
		} else
		if( e.detail !== undefined ){
			this.wheelDeltaX = this.wheelDeltaY = - e.detail * 3;
		} else {
			this.wheelDeltaX = this.wheelDeltaY = 0;
		};
		
		if( e.constructor === window.TouchEvent ){
			// TouchEvent
			this.touches        = e.touches;
			this.changedTouches = e.changedTouches;
			this.targetTouches  = e.targetTouches;
			this.metaKey        = e.metaKey;
			this.force          = e.force || e.webkitForce || 0;
		} else
		if( e.constructor === window.PointerEvent ){
			// PointerEvent;
			this.currentPoint  = e.currentPoint;
			this.width         = e.width;
			this.height        = e.height;
			this.timeStamp     = e.timeStamp;
			this.hwTimestamp   = e.hwTimestamp;
			this.intermediatePoints = e.intermediatePoints;
			this.isPrimary     = e.isPrimary;
			this.pointerId     = e.pointerId;
			this.pointerType   = e.pointerType;
			this.pressure      = e.pressure;
			this.tiltX         = e.tiltX;
			this.tiltY         = e.tiltY;
		};
	};
} else {
	X.Dom.Event = function( e, xnode, element ){
		var btn;
		
		//this._event        = e;
		this.type          = e.type;
		this.target        = Node._getXNode( e.srcElement ); // xnode
		if( this.target && this.target._xnodeType === 3 ) this.target = this.target.parent; // ie4 の fake Textnode がヒットしていないか？
		this.currentTarget = xnode; // xnode
		this.relatedTarget = Node._getXNode( e.formElement ? e.formElement : e.toElement ); // xnode
		this.eventPhase    = e.srcElement === element ? 2: 3;
		
		this.clientX       = e.clientX;
		this.clientY       = e.clientY;
		//this.screenX       = e.screenX;
		//this.screenY       = e.screenY;
		
		if( X.Dom._root ){ // uuu...
			
			this.pageX         = e.clientX + X.Dom._root.scrollLeft;
			this.pageY         = e.clientY + X.Dom._root.scrollTop;
			
			// DOMAssistant 2.8.1
			//event.pageX = DOMAssistant.def(e.pageX)? e.pageX : (event.clientX + (de.scrollLeft || b.scrollLeft) - (de.clientLeft || 0));
			//event.pageY = DOMAssistant.def(e.pageY)? e.pageY : (event.clientY + (de.scrollTop || b.scrollTop) - (de.clientTop || 0));							
		};
		

		
		if( X.UA.IE && 5 <= X.UA.IE ){
			this.offsetX       = e.offsetX; // イベントターゲット左上からの座標
			this.offsetY       = e.offsetY;			
		}// else
		//if( e.srcElement ){
		//	this.offsetX       = e.x - e.srcElement.offsetLeft; // e.x はイベント発生要素の親要素を基準にした座標。
		//	this.offsetY       = e.y - e.srcElement.offsetTop;	
		//};
		
		this.keyCode       = e.keyCode;
		this.altKey        = e.altKey;
		this.ctrlKey       = e.ctrlKey;
		this.shiftKey      = e.shiftKey;
		
		// http://www.programming-magic.com/20090127231544/
		switch( this.type ){
			case 'click'    :
			case 'dblclick' :
				this.which = 1;
				break;
			case 'contextmenu' :
				this.which = 3;
				break;
			default :
				btn = e.button;
				this.which =
					btn & 1 ? 1 :
					btn & 4 ? 2 :
					btn & 2 ? 3 : 0; // 左:1(click:0), 中:4, 右:2
		};
		this.wheelDeltaX = this.wheelDeltaY = e.wheelDelta / 12;
	};
};

X.Dom.Event.DOM_PRE_INIT        = ++X.Event._LAST_EVENT;
X.Dom.Event.DOM_BUILDER_COMPLETE= ++X.Event._LAST_EVENT;
X.Dom.Event.DOM_INIT            = ++X.Event._LAST_EVENT;
X.Dom.Event.XDOM_READY          = ++X.Event._LAST_EVENT;
X.Dom.Event.VIEW_ACTIVATE       = ++X.Event._LAST_EVENT;
X.Dom.Event.VIEW_DEACTIVATE     = ++X.Event._LAST_EVENT;
X.Dom.Event.VIEW_RESIZED        = ++X.Event._LAST_EVENT;
X.Dom.Event.BASE_FONT_RESIZED   = ++X.Event._LAST_EVENT;
// same_page_jump
// on_screen_keyboard_show
// on_screen_keyboard_hide
X.Dom.Event.BEFORE_UPDATE       = ++X.Event._LAST_EVENT;
X.Dom.Event.AFTER_UPDATE        = ++X.Event._LAST_EVENT;
// hash_change
X.Dom.Event.BEFORE_UNLOAD       = ++X.Event._LAST_EVENT;
X.Dom.Event.UNLOAD              = ++X.Event._LAST_EVENT;
X.Dom.Event.LOAD_BEFORE_STOP    = ++X.Event._LAST_EVENT;
X.Dom.Event.LOAD_ASSET_STOP     = ++X.Event._LAST_EVENT;
X.Dom.Event.LOAD_ASSET_COMPLETE = ++X.Event._LAST_EVENT;
X.Dom.Event.LOAD_ASSET_ERROR    = ++X.Event._LAST_EVENT;

X.Dom.Event.ANIME_BEFORE_START  = ++X.Event._LAST_EVENT;
X.Dom.Event.ANIME_START         = ++X.Event._LAST_EVENT;
X.Dom.Event.ANIME               = ++X.Event._LAST_EVENT;
X.Dom.Event.ANIME_END           = ++X.Event._LAST_EVENT;
X.Dom.Event.ANIME_BEFORE_STOP   = ++X.Event._LAST_EVENT; // xnode.stop() のみ、指定時間による停止では呼ばれない
X.Dom.Event.ANIME_STOP          = ++X.Event._LAST_EVENT;
X.Dom.Event._LAST_EVENT         = X.Event._LAST_EVENT; // ここに書いてあるイベントの最後の値 X.Dom.Event.ANIME_STOP と同じ値

X.Dom.Event.Rename = {};
X.Dom.Event.RenameTo = {};
// https://github.com/georgeadamson/jQuery.prefixfree-events/blob/master/jQuery.prefixfree-events.js

if( window.onwebkitanimationend !== undefined && window.onanimationend === undefined ){
	X.Dom.Event.Rename[ 'animationend' ]               = 'webkitAnimationEnd';
	X.Dom.Event.RenameTo[ 'webkitAnimationEnd' ]       = 'animationend';
	X.Dom.Event.Rename[ 'animationstart' ]             = 'webkitAnimationStart';
	X.Dom.Event.RenameTo[ 'webkitAnimationStart' ]     = 'animationstart';
	X.Dom.Event.Rename[ 'animationiteration' ]         = 'webkitAnimationIteration';
	X.Dom.Event.RenameTo[ 'webkitAnimationIteration' ] = 'animationiteration';
};

if( window.onwebkittransitionend !== undefined && window.ontransitionend === undefined ){
	X.Dom.Event.Rename[ 'transitionend' ]         = 'webkitTransitionEnd';
	X.Dom.Event.RenameTo[ 'webkitTransitionEnd' ] = 'transitionend';
};

X.Dom.Node.prototype.listen = function( type, arg1, arg2, arg3 /* [ listener || ( context + function ) || function ][ arguments ] */ ){
	var elm;
	
	if( this._xnodeType === 0 || this._xnodeType === 3 || !arg1 ) return this;
	
	( !this._listeners || !this._listeners[ type ] ) && X.Type.isString( type ) && this._addEvent( type );
	
	return typeof arg1 === 'function' ?
		X.EventDispatcher.prototype.listen.call( this, type, this, arg1, arg2 ) :
		X.EventDispatcher.prototype.listen.apply( this, arguments );
};

X.Dom.Node.prototype._addEvent =
	// Days on the Moon DOM Events とブラウザの実装 
	// http://nanto.asablo.jp/blog/2007/03/23/1339502
	// Safari 2 では関数オブジェクトしか EventListener として使えませんが、Safari のナイトリービルドでは handleEvent メソッドを持つオブジェクトも EventListener として使えるようです。
	X.Dom.EVENT_W3C && X.UA.Safari && X.UA.Safari < 3 ?
		(function( type ){
			var raw = this._rawNode;
			if( !raw ) return;
			this._handleEvent = this._handleEvent || X.Callback.create( this );
			if( this._isImage ){
				raw[ 'on' + type ] = this._handleEvent;
			} else {
				raw.addEventListener( type, this._handleEvent, false );
			};
		}) :
	X.Dom.EVENT_W3C ?
		(function( type ){
			this._rawNode && this._rawNode.addEventListener( X.Dom.Event.Rename[ type ] || type, this, false );
		}) :
	X.Dom.EVENT_IE ?
		(function( type ){
			if( !this._rawNode ) return;
			this._handleEvent = this._handleEvent || X.Callback.create( this );
			this._rawNode.attachEvent( 'on' + type, this._handleEvent );
		}) :
		(function( type ){
			var elm = this._ie4getRawNode();
			if( !elm ) return;
			this._handleEvent = elm[ 'on' + type ] = this._handleEvent || X.Callback.create( this );
		});


X.Dom.Node.prototype.unlisten = function( type /* , arg1, arg2, arg3 */ ){
	var list = this._listeners,
		l    = !this._dispatching && list && type !== undefined && list[ type ] && list[ type ].length;
	
	X.EventDispatcher.prototype.unlisten.apply( this, arguments );
	
	l && !list[ type ] && X.Type.isString( type ) && this._removeEvent( type );
	
	return this;
};

X.Dom.Node.prototype._removeEvent =
	X.Dom.EVENT_W3C && X.UA.Safari && X.UA.Safari < 3 ?
		(function( type ){
			var raw = this._rawNode;
			if( !raw ) return;
			
			if( raw.constructor === Image ){
				raw[ 'on' + type ] = '';
			} else {
				raw.removeEventListener( type, this._handleEvent, false );
			};
			if( !this._listeners ){
				X.Callback._correct( this._handleEvent );
				delete this._handleEvent;
			};
		}) :
	X.Dom.EVENT_W3C ?
		(function( type ){
			var elm = this._rawNode;
			if( !elm ) return;
			elm.removeEventListener( X.Dom.Event.Rename[ type ] || type, this, false );
		}) :
	X.Dom.EVENT_IE ?
		(function( type ){
			var elm = this._rawNode;
			if( !elm ) return;
			elm.detachEvent( 'on' + type, this._handleEvent );
			if( !this._listeners ){
				X.Callback._correct( this._handleEvent );
				delete this._handleEvent;
			};
		}) :
		(function( type ){
			var elm = this._rawNode || this._ie4getRawNode();
			if( !elm ) return;
			elm[ 'on' + type ] = X.emptyFunction;
			elm[ 'on' + type ] = '';
			if( !this._listeners ){
				X.Callback._correct( this._handleEvent );
				delete this._handleEvent;
			};
		});

// Is this in regard to the Safari 1.x preventDefault bug on click/dblclick?
// https://groups.google.com/forum/#!msg/comp.lang.javascript/uYEuCHjHxnw/yKoHtZJPa1QJ

X.Dom.Node.prototype.handleEvent =
	X.Dom.EVENT_W3C ?
		(function( e ){
			var ret = X.EventDispatcher.prototype.dispatch.call( this, new X.Dom.Event( e, this ) );
			
			if( ret & X.Callback.STOP_PROPAGATION ){
				e.stopPropagation();
			};
			if( ret & X.Callback.PREVENT_DEFAULT ){
				this._tag === 'A' && this._rawNode.blur();
				e.preventDefault();
				if( X.UA.Safari && X.UA.Safari < 3 ){
					if( e.type === 'click' || e.type === 'dbclick' ){
						X.Dom._safariPreventDefault = true;
					};
				};
				return false;
			};
		}) :
		(function(){
			var ret = X.EventDispatcher.prototype.dispatch.call( this, new X.Dom.Event( event, this, this._rawNode ) );

			if( ret & X.Callback.STOP_PROPAGATION ){
				event.cancelBubble = true;
			};
			if( ret & X.Callback.PREVENT_DEFAULT ){
				this._tag === 'A' && this._rawNode.blur();
				return event.returnValue = false;
			};
		});


// イベントの退避、dom が画面から抜かれる場合に実施しておく
X.Dom.Node.prototype._migrateEvent = function(){
	var hash = this._listeners,
		type;
	if( !hash ) return;
	for( type in hash ){
		this._removeEvent( type );
	};
};

// 退避したイベントの復帰
X.Dom.Node.prototype._restoreEvent = function(){
	var hash = this._listeners,
		type;
	if( !hash ) return;
	for( type in hash ){
		this._addEvent( type );
	};
};

/* -----------------------------------------------
 * Document Ready
 *  Dean Edwards/Matthias Miller/John Resig
 */

// SafariでJavaScriptのデバッグをする方法
// safari1.3 可
// http://shimax.cocolog-nifty.com/search/2006/09/safarijavascrip_c54d.html

// Re: onLoad doesn't work with Safari?
// http://lists.apple.com/archives/web-dev/2003/Oct/msg00036.html
if( X.UA.Safari && X.UA.Safari < 3 ){
	X.Timer.add( 10, function(){
		if( !X.Dom._init ) return X.Callback.UN_LISTEN;
		if( 'loaded|complete'.indexOf( document.readyState ) !== -1 ) return X.Dom._init();
	} );
} else

/* for ie9+/Mozilla/Opera9 */
if( X.Dom.DOM_W3C ){
	Node._document.listenOnce( 'DOMContentLoaded', X.Dom._init );
} else
if( 5 <= X.UA.IE && X.inHead ){
	// if this script in Head
	document.write( "<script id=__ie_onload defer src=javascript:void(0)><\/script>" );
	X.Dom._script = document.getElementById( "__ie_onload" );
	X.Dom._script.onreadystatechange = function(){
		this.readyState === 'complete' && X.Dom._init();
	};
} else
if( X.UA.WebKit ){ // sniff
	X.Timer.add( 10, function(){
		if( !X.Dom._init ) return X.Callback.UN_LISTEN;
		if( 'loaded|complete'.indexOf( document.readyState ) !== -1 ) return X.Dom._init();
	});
};
	/* for other browsers */
	Node._window.listenOnce( 'load', X.Dom._init );	




//
X.Dom.listenOnce( X.Dom.Event.XDOM_READY, function(e){
	console.log( 'X.Dom XDomReady ' + X.Dom.readyState );
} );

if( X.UA.Safari && X.UA.Safari < 3 ){
	document.documentElement.onclick =
	document.documentElement.ondbclick = function( e ){
			if( X.Dom._safariPreventDefault ){
				X.Dom._safariPreventDefault = false;
				e.preventDefault();
				return false;
			};
		};
};

X.Dom.listenOnce( X.Dom.Event.VIEW_RESIZED, function(e){ console.log( 'X.Dom VIEW_RESIZED ' + e.w + 'x' + e.h ); } );

