X.Dom.BoxModel = {
	CONTENT_BOX      : 1,
	PADDING_BOX      : 2,
	BORDER_BOX       : 3,
		
	defaultBoxModel  : 0,
	boxSizingEnabled : false,
	
	// TODO: offsetLeft, offsetTop の基準位置
	absoluteOffset   : 0,
	
	vScrollbarSize   : 0,
	hScrollbarSize   : 0
};

X.Dom.listenOnce( X.Dom.Event.DOM_INIT, function(){

	var elm = Node._systemNode._rawNode || Node._systemNode._ie4getRawNode();
	elm.style.cssText = 'width:10px;padding:1px;border:2px solid #0;margin:4px;';
	
	X.Dom.BoxModel.defaultBoxModel = elm.offsetWidth === 10 ?
		X.Dom.BoxModel.BORDER_BOX :
		X.Dom.BoxModel.CONTENT_BOX;
	
	if( X.Dom.BoxModel.defaultBoxModel === X.Dom.BoxModel.CONTENT_BOX ){
		elm.style.cssText += 'box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing: border-box;-o-box-sizing:border-box;-ms-box-sizing:border-box;';
		
		X.Dom.BoxModel.boxSizingEnabled = elm.offsetWidth === 10;
	};
	// padding
	// border
	// margin
	// top

	elm.style.cssText = 'width:90px;height:90px;overflow:auto;';
	elm.innerHTML = '<div style="width:100px;height:100px;"></div>';
	
	X.Dom.BoxModel.vScrollbarSize = 90 - elm.clientWidth;
	X.Dom.BoxModel.hScrollbarSize = 90 - elm.clientHeight;

	elm.style.cssText = 'position:absolute;top:0;left:0;margin:1px;border:2px solid #000;padding:4px;';
	elm.children[ 0 ].style.cssText = 'position:absolute;top:8px;left:8px;margin:16px;border:32px solid #666;padding:64px;';

	X.Dom.BoxModel.absoluteOffset = elm.children[ 0 ].offsetTop;

	elm.style.cssText = elm.innerHTML = '';
});

/* --------------------------------------
 * Width, Height
 *  display:blobk かつ overflow:hidden かつ size（px,em）が設定されていたら、再描画しないでその値を返す
 *  display:none なら 0
 */
Node.prototype.width = function(){
	if( !this.parent ){// todo : _state で tree に所属しているか？判定
		console.log( 'xnode.width() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.width() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'width' );
		return this._rawNode.offsetWidth;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).offsetWidth;
	} else {
		
	};
};

Node.prototype.height = function(){
	if( !this.parent ){
		console.log( 'xnode.height() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.height() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'height' );
		return this._rawNode.offsetHeight;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).offsetHeight;
	} else {
		
	};
};

Node.prototype.scrollWidth = function(){
	if( !this.parent ){// todo : _state で tree に所属しているか？判定
		console.log( 'xnode.width() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.width() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'width' );
		return this._rawNode.scrollWidth;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).scrollWidth;
	} else {
		
	};
};

Node.prototype.scrollHeight = function(){
	if( !this.parent ){
		console.log( 'xnode.height() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.height() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'height' );
		return this._rawNode.scrollHeight;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).scollHeight;
	} else {
		
	};
};


/* --------------------------------------
 *  x, y
 *  position:absolute かつ x か y が設定されていたら、再描画しないで css オブジェクトから計算した値を返す。 float は?
 *  position:absolute の指定で自動で top,left を補う必要あり？ -> X.Dom.Style
 *  親要素 border 外側からの値。 IE, Firefox, Safari, Chrome の offsetLeft/Topでは、border 内側なので補正する。
 * transformX, Y は加える？ アニメーション中は？
 */
// X.Dom.Style.transform,
Node.prototype.x = function(){
	if( !this.parent ){
		console.log( 'xnode.x() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.x() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'left' );
		// this.css( X.Dom.Style.Unit.px, 'translateX' );
		return this._rawNode.offsetLeft;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).offsetLeft;
	} else {
		
	};
};

Node.prototype.y = function(){
	if( !this.parent ){
		console.log( 'xnode.y() : no parent' );
		return 0;
	};
	Node.root._updateTimerID && Node.root._startUpdate();
	if( !this._root ){
		console.log( 'xnode.y() : not belong tree.' );
		return 0;
	};
	if( this._state & X.Dom.State.DISPLAY_NONE ) return 0;
	if( X.Dom.DOM_W3C ){
		// this.css( X.Dom.Style.Unit.px, 'top' );
		// this.css( X.Dom.Style.Unit.px, 'transisitonY' );
		return this._rawNode.offsetTop;
	} else
	if( X.Dom.DOM_IE4 ){
		return ( this._rawNode || this._ie4getRawNode() ).offsetTop;		
	} else {
		
	};
};

