using System;
using System.Collections.Generic;
using System.Text;

namespace SCFiler2.Operation {
	/// <summary>
	/// SĂAction(Action̎qNX)Ǘ
	/// VOg
	/// </summary>
	public class ActionManager {
		static private ActionManager instance = new ActionManager();
		static public ActionManager Instance {
			get { return instance;}
		}

		private ActionManager () {
		}

		public enum ActionID : int {
			//FileOperation
			CopyToAnotherFileView = 1,
			CopyDialog,
			MoveToAnothierFileView,
			MoveDialog,
			MoveToRecycle,
			DeleteSelectedItem,
			DeleteDialog,
			ExecuteFocusedItem,
			OpenByExplorer,
			CreateFolder,
			Rename,
			CopyToClipboard,
			CutToClipboard,
			ClearClipboard,
			PasteClipboard,
			FileSearch, 
			 

			//View
			setFocusToLeftFileView,
			setFocusToRightFileView,
			GoToSameFolderAsAnotherView,
			RecordFileViewSnapshots,
			RestoreFileViewSnapshots,
			IncrementalSearch,
			MigemoSearch,
			EasySelect,
			SelectAll,
			RefleshAll,
			PreviewMode,
			ThumbnailMode,
			Sort,
			SwitchNarrowDownMode,

			//Application
			ExitApplication,
			MinimizeApplication,

			//Move
			MoveToParentFolder,
			MoveToDriveRoot,
			MoveBackword,
			MoveForword,
			AddToJumpFolder,
			GoToJumpFolder,
			MoveToDriveCatalogue,

			//Tool
			ExecuteExternalTool1,
			ExecuteExternalTool2,
			ExecuteExternalTool3,
			ExecuteExternalTool4,
			ExecuteExternalTool5
		}

		/// <summary>
		/// PAction̊ǗĂNX
		/// </summary>
		private class ActionManageUnit {
			public ActionManageUnit(ActionID id, string displayString) {
				this.id = id;
				this.displayString = displayString;
			}
			public ActionID id;
			public string displayString;
		}

		static public IEnumerable<ActionID> AllActionID {
			get {
				foreach (ActionID id in Enum.GetValues(typeof(ActionID))) {
					yield return id;
				}
			}
		}

		static public string GetDisplayString(ActionID id) {
			//CreateActionōCX^XQƂꑱ̂h߁Astring̃Rs[nĂ
			return string.Copy(CreateAction(id).DisplayString);
		}

		static public Action CreateAction(ActionID id) {
			switch (id) {
				//FileOperation
				case ActionID.CopyToAnotherFileView:
					return new CopyToAnotherFileVIew();
				case ActionID.CopyDialog:
					return new CopyDialog();
				case ActionID.MoveDialog:
					return new MoveDialog();
				case ActionID.MoveToAnothierFileView:
					return new MoveToAnotherFileView();
				case ActionID.MoveToRecycle:
					return new MoveToRecycle();
				case ActionID.DeleteSelectedItem:
					return new DeleteSelectedItem();
				case ActionID.DeleteDialog:
					return new DeleteDialog();
				case ActionID.ExecuteFocusedItem:
					return new ExecuteFocusedItem();
				case ActionID.OpenByExplorer:
					return new OpenByExplorer();
				case ActionID.CreateFolder:
					return new CreateFolder();
				case ActionID.Rename:
					return new Rename();
				case ActionID.CopyToClipboard:
					return new CopyToClipboard();
				case ActionID.CutToClipboard:
					return new CutToClipboard();
				case ActionID.ClearClipboard:
					return new ClearClipboard();
				case ActionID.PasteClipboard:
					return new PasteClipboard();

				//View
				case ActionID.setFocusToLeftFileView:
					return new setFocusToLeftFileView();
				case ActionID.setFocusToRightFileView:
					return new setFocusToRightFileView();
				case ActionID.GoToSameFolderAsAnotherView:
					return new GoToSameFolderAsAnotherView();
				case ActionID.RecordFileViewSnapshots:
					return new RecordFileViewSnapshots();
				case ActionID.RestoreFileViewSnapshots:
					return new RestoreFileViewSnapshots();
				case ActionID.IncrementalSearch:
					return new IncrementalSearch();
				case ActionID.MigemoSearch:
					return new MigemoSearch();
				case ActionID.FileSearch:
					return new FileSearch();
				case ActionID.EasySelect:
					return new EasySelect();
				case ActionID.SelectAll:
					return new SelectAll();
				case ActionID.RefleshAll:
					return new RefleshAll();
				case ActionID.PreviewMode:
					return new PreviewMode();
				case ActionID.ThumbnailMode:
					return new ThumbnailMode();
				case ActionID.Sort:
					return new Sort();
				case ActionID.SwitchNarrowDownMode:
					return new NarrowDownFileViewItem();

				//Application
				case ActionID.ExitApplication:
					return new ExitApplication();
				case ActionID.MinimizeApplication:
					return new MinimizeApplication();

				//Move
				case ActionID.MoveToParentFolder:
					return new MoveToParentFolder();
				case ActionID.MoveToDriveRoot:
					return new MoveToDriveRoot();
				case ActionID.MoveBackword:
					return new MoveBackword();
				case ActionID.MoveForword:
					return new MoveForword();
				case ActionID.AddToJumpFolder:
					return new AddToJumpFolder();
				case ActionID.GoToJumpFolder:
					return new GoToJumpFolder();
				case ActionID.MoveToDriveCatalogue:
					return new MoveToDriveCatalogue();

				//Tool
				case ActionID.ExecuteExternalTool1:
					return new ExecuteExternalTool1();
				case ActionID.ExecuteExternalTool2:
					return new ExecuteExternalTool2();
				case ActionID.ExecuteExternalTool3:
					return new ExecuteExternalTool3();
				case ActionID.ExecuteExternalTool4:
					return new ExecuteExternalTool4();
				case ActionID.ExecuteExternalTool5:
					return new ExecuteExternalTool5();
				default:
					System.Diagnostics.Debug.Assert(false);
					return null;
			}

		}
	}
}
