using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Operation;
using SCFiler2.CommonDialog;
using System.Windows.Forms;
using SCFiler2.ViewInterface;
using System.IO;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	/// <summary>
	/// Rs[I_CAOoăRs[s
	/// </summary>
	public class CopyDialog : Action {
		public override string DisplayString {
			get { return "Rs[IŃRs["; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView activeView = ViewInterfaces.LastFocusedFileView;
			IFileView inactiveView = ViewInterfaces.OtherOfLastFocusedFileView;

			if (activeView.CurrentPath == "") {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
				return;
			}

			if (activeView.SelectedFilerItems.Count == 0) {
				SCFiler2System.ShowTempMessage("t@CIĂ܂");
				return;
			}

			OperationTargetDialog dialog = new OperationTargetDialog();
			dialog.DialogTitle = "Rs[I";
			DialogResult result = dialog.ShowDialog();

			if (result == DialogResult.OK) {
				OperationTargetDialog.Target target = dialog.SelectedTarget;
				switch (target) {
					case OperationTargetDialog.Target.AnotherView:
						if (inactiveView.CurrentPath == "") {
							SCFiler2System.ShowTempMessage("΂̃r[̓hCuꗗ\Ă̂ŃRs[ł܂");
							return;
						}

						List<IFilerItem> list = activeView.SelectedFilerItems;
						string destFolder = inactiveView.CurrentPath;
						CopyJob copyJob;
						try {
							copyJob = new CopyJob(new Folder(destFolder), list);
						} catch (InvalidPreConditionJobException e) {
							SCFiler2System.ShowDialogMessage(e.Message);
							return;
						}

						if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
							JobManager.Instance.AddJob(copyJob);
						} else {
							JobManager.Instance.ExecuteJobNow(copyJob);
						}
						ViewInterfaces.CheckUpdateAllView();
						activeView.UpdateView();
						inactiveView.UpdateView();
						activeView.SelectMode = SelectMode.Normal;
						inactiveView.SelectMode = SelectMode.Normal;
						inactiveView.ViewMode = ViewMode.Normal;
						break;

					case OperationTargetDialog.Target.Clipboard:
						ClipboardManager.SendToClipboard(ClipboardManager.EffectType.Copy, activeView.SelectedFilerItems);
						SCFiler2System.ShowTempMessage("IACeNbv{[hɃRs[܂");
						ViewInterfaces.CheckUpdateAllView();
						break;

					case OperationTargetDialog.Target.JumpFolder:
						JumpFolderDialog jumpDialog = new JumpFolderDialog();
						DialogResult jumpDialogResult = jumpDialog.ShowDialog();
						if (jumpDialogResult == DialogResult.OK) {
							IJumpFolder jumpFolder = jumpDialog.SelectedJumpFolder;

							CopyJob copyJob2;
							try {
								copyJob2 = new CopyJob(jumpFolder.Folder, activeView.SelectedFilerItems);
							} catch (InvalidPreConditionJobException e) {
								SCFiler2System.ShowDialogMessage(e.Message);
								return;
							}


							if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
								JobManager.Instance.AddJob(copyJob2);
							} else {
								JobManager.Instance.ExecuteJobNow(copyJob2);
							}
						} else {
							SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
							return;
						}
						activeView.SelectMode = SelectMode.Normal;
						ViewInterfaces.CheckUpdateAllView();
						break;
					case OperationTargetDialog.Target.RightUnder:
						List<IFilerItem> directoryList = new List<IFilerItem>();
						DirectoryInfo info = new DirectoryInfo(activeView.CurrentPath);
						DirectoryInfo[] directories = info.GetDirectories();
						foreach (DirectoryInfo item in directories) {
							directoryList.Add(new Folder(item.FullName));
						}

						FilerItemSelectDialog selectDialog = new FilerItemSelectDialog();
						selectDialog.setItems(directoryList);
						selectDialog.DialogTitle = "Rs[IĂ";
						DialogResult selectResult = selectDialog.ShowDialog();
						if (selectResult == DialogResult.OK) {

							CopyJob copyJob3;
							try {
								copyJob3 = new CopyJob(new Folder(selectDialog.SelectedItem.FullName), activeView.SelectedFilerItems);
							} catch (InvalidPreConditionJobException e) {
								SCFiler2System.ShowDialogMessage(e.Message);
								return;
							}


							if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
								JobManager.Instance.AddJob(copyJob3);
							} else {
								JobManager.Instance.ExecuteJobNow(copyJob3);
							}
							activeView.SelectMode = SelectMode.Normal;
							ViewInterfaces.CheckUpdateAllView();
						} else {
							SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
							return;
						}
						break;
				}
			} else {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
				return;
			}
				
		}
	}
}
