using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class CopyToAnotherFileVIew : Action {
		public override string DisplayString {
			get { return "ACe𔽑΂̃r[ɃRs["; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView activeView = ViewInterfaces.LastFocusedFileView;
				IFileView inactiveView = ViewInterfaces.OtherOfLastFocusedFileView;

				if (activeView.CurrentPath == "" || inactiveView.CurrentPath == "") {
					SCFiler2System.ShowDialogMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				List<IFilerItem> list = activeView.SelectedFilerItems;
				string destFolder = inactiveView.CurrentPath;

				CopyJob job;
				try {
					job = new CopyJob(new Folder(destFolder), list);
				} catch (InvalidPreConditionJobException e) {
					SCFiler2System.ShowDialogMessage(e.Message);
					return;
				}

				if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
					JobManager.Instance.AddJob(job);
				} else {
					JobManager.Instance.ExecuteJobNow(job);

					inactiveView.UpdateView();
					activeView.SelectMode = SelectMode.Normal;
					inactiveView.SelectMode = SelectMode.Normal;
					inactiveView.ViewMode = ViewMode.Normal;
				}
			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
