using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SCFiler2 {
	delegate void ListViewFocusChangedDelegate(int index);

	/// <summary>
	/// Xgr[ɃtH[JXړCxgǉ邽߂̃NX
	/// </summary>
	class CustomListView : ListView {
		internal ListViewFocusChangedDelegate FocusChanged = null;

		//̃\bh̎
		//http://hongliang.seesaa.net/article/16550502.html
		//ŌJĂR[hgpĂ܂
		protected override void WndProc(ref Message m) {
			// LVN_ITEMCHANGED ͐etH[ WM_NOTIFY(0x4E)őMA
			//    etH[͂YRg[
			//    WM_REFLECT(WM_USER(0x400)+0x1C00) ǉbZ[WR[hŒʒmB
			const int ReflectedItemChanged = 0x400 + 0x1c00 + 0x4e;
			// LVN_ITEMCHANGED
			const int ItemChanged = -101;
			// NMHDR / NMLISTVIEW \̂ɂ郁õItZbgi擪 hdr j
			const int OffsetCode = 4, OffsetIndex = 8, OffsetState = 16, OffsetOldState = 24;
			if (m.Msg == ReflectedItemChanged) {
				// LPARAM  NMHDR ɌĂĒʒmR[h(code)擾
				int code = Marshal.ReadInt32(m.LParam, IntPtr.Size + OffsetCode);
				if (code == ItemChanged) {
					// LPARAM  NMLISTVIEW ɌĂăACȅ(uNewState)擾
					int state = Marshal.ReadInt32(m.LParam, IntPtr.Size + OffsetState);

					const int Focused = 1;
					// ŉʃrbgĂꍇtH[JX݂ƌӖɂȂ
					// tH[JXACe 1 ACe 2 ɓꍇA
					//    ItemChanged ͕񑗂B
					//    ʓIɁAACe 1 ̑IAACe 1 ̃tH[JXA
					//    ACe 2 ̃tH[JXƑIԂ̊lȀłB
					//    ACe 1 ̏ԂɂĂ uOldState ̕Ɍ̂ŁA
					//    state (uNewState) ɏo邱Ƃ͂Ȃ
					if ((state & Focused) != 0) {
						// LPARAM  NMLISTVIEW ɌĂăCfbNX(iItem)擾
						int index = Marshal.ReadInt32(m.LParam, IntPtr.Size + OffsetIndex);
						if (this.FocusChanged != null) {
							this.FocusChanged(index);
						}
					}
				}
			}
			base.WndProc(ref m);
		}
	}
}
