using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class CutToClipboard : Action {
		public override string DisplayString {
			get { return "Nbv{[hɐ؂"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				if (view.SelectedFilerItems.Count == 0) {
					SCFiler2System.ShowTempMessage("t@CIĂ܂");
					return;
				}

				ClipboardManager.SendToClipboard(ClipboardManager.EffectType.Cut, view.SelectedFilerItems);
				ViewInterfaces.CheckUpdateAllView();
				view.SelectMode = SelectMode.Normal;
				ViewInterfaces.OtherOfLastFocusedFileView.ViewMode = ViewMode.Normal;
				SCFiler2System.ShowTempMessage("IACeNbv{[hɐ؂܂");
			} else {
				//FileViewȊO͉Ȃ
				SCFiler2System.ShowTempMessage("FileViewɃtH[JXԂŎsĂ");
			}
		}
	}
}
