using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.CommonDialog;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class DeleteSelectedItem : Action {
		public override string DisplayString {
			get { return "폜"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView activeView = ViewInterfaces.LastFocusedFileView;
				if (activeView.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				Messagebox.DialogResult result = Messagebox.Show("mF", "{ɍ폜Ă낵łH");
				if (result == Messagebox.DialogResult.No) {
					Messagebox.Show(Messages.COMMAND_CANCELED);
					return;
				}
				
				List<IFilerItem> list = activeView.SelectedFilerItems;
				SCFiler2System.ShowTempMessage("폜Jn܂");

				DeleteJob job = new DeleteJob(list, false);
				if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
					JobManager.Instance.AddJob(job);
				} else {
					JobManager.Instance.ExecuteJobNow(job);

					activeView.UpdateView();
					activeView.SelectMode = SelectMode.Normal;
					SCFiler2System.ShowTempMessage("폜܂");
				}

				//TODO 폜ɃtH[JX폜ACëɓ

			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
