using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using System.Diagnostics;
using SCFiler2.Util;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class ExecuteFocusedItem : Action {
		public override string DisplayString {
			get { return "s"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			IItemView view = ViewInterfaces.CurrentItemView;
			List<IFilerItem> list = view.SelectedFilerItems;
			if (list.Count == 0) {
				SCFiler2System.ShowTempMessage("t@CIĂ܂");
				return;//Ƃ肠Ȃ
			} else if (list.Count > 1) {
				SCFiler2System.ShowTempMessage("IĂ̎s̓T|[gĂ܂");
				return;
			}
			IFilerItem item = list[0];
			if (!item.Exists) {
				SCFiler2System.ShowDialogMessage("IꂽACe܂B폜܂͈ړꂽ\܂");
				view.UpdateView();
				return;
			}

			if (item.Type == ItemType.Folder || item.Type == ItemType.Drive) {
				//tH_hCu炻̃tH_̒Ɉړ
				IFileView fileView = ViewInterfaces.LastFocusedFileView;
				fileView.ChangePath(item.FullName);
				fileView.Focus();
			} else if (item.Type == ItemType.File ){
				ExtensionRelationCustomize.Instance.Execute(item);
				ViewInterfaces.OtherOfLastFocusedFileView.ViewMode = ViewMode.Normal;
			}
			ViewInterfaces.LastFocusedFileView.SelectMode = SelectMode.Normal;
		}
	}
}
