using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using System.Diagnostics;
using SCFiler2.ItemInterface;
using System.Drawing;

namespace SCFiler2.FileSystem {
	public sealed class File : FilerItem , IFile {
		System.IO.FileInfo info;


		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="fullName">t@CtpXŏ</param>
		public File(string fullName) {
			this.info = new System.IO.FileInfo(fullName);
		}

		public File(System.IO.FileInfo info) {
			this.info = info;
		}

		/// <summary>
		/// ACet@CtH_
		/// </summary>
		public override ItemType Type {
			get { return ItemType.File; }
		}

		/// <summary>
		/// t@C̊gq̖O
		/// </summary>
		public override string NameWithoutExtension {
			get { return System.IO.Path.GetFileNameWithoutExtension(info.FullName); }
		}

		/// <summary>
		/// SCFilerł̕\pɉHTCY\
		/// </summary>
		public override string SizeDisplayString {
			get { 
				return DisplayUtil.SizeToString(info.Length);
			}
		}

		/// <summary>
		/// t@C݂pX
		/// </summary>
		override public string Path {
			get { return System.IO.Path.GetDirectoryName(info.FullName); }
		}

		/// <summary>
		/// t@CbytePʂł̃TCY
		/// </summary>
		public long Size {
			get { return info.Length; }
		}

		override public string FullName {
			get { return this.info.FullName; }
		}

		override public string Name {
			get { return this.info.Name; }
		}

		public override string Extension {
			get { return this.info.Extension; }
		}

		public override string UpdateDateString {
			get { return this.info.LastWriteTime.ToString("yy/MM/dd HH:mm"); }
		}

		public DateTime UpdateDate {
			get { return this.info.LastWriteTime; }
		}

		public override bool Exists {
			get { return this.info.Exists; }
		}

		public override void Refresh() {
			this.info.Refresh();
		}

		public System.IO.FileAttributes Attributes {
			get { return this.info.Attributes; }
			set { this.info.Attributes = value; }
		}

		public override System.Drawing.Icon Icon {
			get { return System.Drawing.Icon.ExtractAssociatedIcon(this.info.FullName); }
		}

		/// <summary>
		/// t@Cs
		/// </summary>
		public void Execute() {
			ExtensionRelationCustomize.Instance.Execute(this);
		}

		Image image = null;
		public override System.Drawing.Image ThumnailImage {
			get { 
				if (image != null) {
					return image;
				}
				Image originalImage = ImageUtil.GetImage(this);
				if (originalImage == null) {
					return Images.DefaultThumbnail;
				}
				this.image = ImageUtil.GetSizeTransformedImage(originalImage,
					SCFiler2System.Instance.Option.FileView.ThumbnailWidth,
					SCFiler2System.Instance.Option.FileView.ThumbnailHeight,
					false);
				originalImage.Dispose();
				return this.image;
			}
		}

		public override bool Equals(object obj) {
			if (obj == null || this.GetType() != obj.GetType()) {
				return false;
			} else {
				return this.FullName == ((File)obj).FullName;
			}
		}

		public override int GetHashCode() {
			return this.FullName.GetHashCode();
		}
    }
}
