﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class FileSearch : Action {
		public override string DisplayString {
			get { return "ファイル検索"; }
		}

		public override ActionType Type {
			get { return ActionType.View; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage("ListViewにフォーカスがありません");
				return;
			}

			IFileView view = ViewInterfaces.LastFocusedFileView;

			if (view.CurrentPath == "") {
				SCFiler2System.ShowTempMessage("ドライブ一覧の画面では検索できません");
				return;
			}

			FileSearchForm searchForm = new FileSearchForm(view.CurrentPath);
			System.Windows.Forms.DialogResult result = searchForm.ShowDialog();
			if (result == System.Windows.Forms.DialogResult.Cancel) {
				SCFiler2System.ShowTempMessage("検索をキャンセルしました");
				return;
			}
			FilerItem item = searchForm.SelectedItem;
			if (item != null) {
				if (item.Type == ItemType.Folder) {
					view.ChangePath(item.FullName);
					view.Focus();
				} else {
					view.ChangePath(item.Path, item.FullName);
					view.Focus();
				}
			}
			view.SelectMode = SelectMode.Normal;
		}
	}
}
