using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using SCFiler2.FileSystem;

namespace SCFiler2 {
	/// <summary>
	/// t@CʃXbhŎs邽߂ɁAʃXbhœ𔲂oNXi킩₷̂ߔoj
	/// </summary>
	public class FileSearchThread {
		/// <summary>
		/// ̃XbhtH[
		/// </summary>
		FileSearchForm form;
		
		//tH[ɏ󋵂ʒm邽߂̃fQ[gQ
		private FileSearchForm.PrintFullNameLabelDelegate printFullNameLabelDelegate;
		private FileSearchForm.AddFoundItemDelegate addFoundItemDelegate;
		private FileSearchForm.RecordErrorDelegate recordErrorDelegate;
		private FileSearchForm.NotifySearchEndDelegate notifySearchEndDelegate;

		/// <summary>
		/// ̃XbhIvǂ
		/// </summary>
		private bool isRequestEnd;

		private string searchPath = "";
		/// <summary>
		/// Ώۂ̃[g̃pX
		/// </summary>
		public string SearchPath {
			set { searchPath = value; }
		}

		private string searchString = "";
		/// <summary>
		/// Ώۂ̕
		/// </summary>
		public string SearchString {
			set { searchString = value; }
		}

		public FileSearchThread(FileSearchForm form) {
			this.form = form;
			this.printFullNameLabelDelegate = new FileSearchForm.PrintFullNameLabelDelegate(form.PrintFullNameLabel);
			this.addFoundItemDelegate = new FileSearchForm.AddFoundItemDelegate(form.AddFoundItem);
			this.recordErrorDelegate = new FileSearchForm.RecordErrorDelegate(form.RecordError);
			this.notifySearchEndDelegate = new FileSearchForm.NotifySearchEndDelegate(form.NotifySearchEnd);
		}

		/// <summary>
		/// ̊Jn
		/// </summary>
		public void Start() {
			if (searchString == "" || searchPath == "") {
				return;
			}
			isRequestEnd = false;
			Search(this.searchPath, this.searchString);
			if (form.IsHandleCreated) {
				form.Invoke(this.notifySearchEndDelegate);
			}
		}

		/// <summary>
		/// ̏I
		/// </summary>
		public void End() {
			isRequestEnd = true;
			this.printFullNameLabelDelegate = null;
			this.addFoundItemDelegate = null;
			this.recordErrorDelegate = null;
			this.notifySearchEndDelegate = null;
		
		}

		/// <summary>
		/// ̃tH_ȉ̃t@CBexecute()ĂяoBitemFound()ĂяoB
		/// </summary>
		/// <param name="searchPath">stH_̃pX</param>
		/// <param name="searchName">镶</param>
		public void Search(string searchPath, string searchString) {
			if (isRequestEnd) {
				return;
			}

			form.Invoke(printFullNameLabelDelegate, new object[] {"F" + searchPath});

			//searchPath̒ɂtH_̎擾
			try {
				string[] folders = System.IO.Directory.GetDirectories(searchPath);
				//tH_ɑ΂search()ċAĂяo
				foreach (string folder in folders) {
					if (isRequestEnd) {
						return;
					}

					//tH_̖OɈĂ邩`FbN
					string folderName = System.IO.Path.GetFileName(folder).ToLower(); //΃pX̒ApXtH_擾
					if (folderName.IndexOf(searchString) >= 0) {
						FoundItem(new Folder(folder));
					}
					//tH_̒ċN
					Search(folder, searchString);
				}

				//tH_̒ɂt@C̎擾
				string[] files = System.IO.Directory.GetFiles(searchPath);
				//ꂼ̃t@C܂ł邩̃`FbN
				foreach (string file in files) {
					string fileName = System.IO.Path.GetFileName(file).ToLower();
					if (fileName.IndexOf(searchString) >= 0) {
						FoundItem(new File(file));
					}
				}
			} catch (Exception e) {
				if (form.IsHandleCreated) {
					form.Invoke(recordErrorDelegate, new object[] { searchPath + ":" + e.Message });
				}
			}
		}

		/// <summary>
		/// ACe̏
		/// </summary>
		/// <param name="item">ACe</param>
		private void FoundItem(FilerItem item) {
			if (form.IsHandleCreated){ 
				form.Invoke(addFoundItemDelegate, new object[] { item });
			}
		}

	}
}
