using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Drawing;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	public abstract class FilerItem : IFilerItem {
		/// <summary>
		/// File/Folderʂ^Cv
		/// </summary>
		abstract public ItemType Type { get;}

		/// <summary>
		/// t@C̏ꍇ́Ãt@CtH_BtH_̏ꍇ́A̐etH_B
		/// </summary>
		abstract public string Path { get; }

		/// <summary>
		/// Ogq́BtH_̏ꍇ̓tH_̂́B
		/// </summary>
		abstract public string NameWithoutExtension { get;}

		/// <summary>
		/// t@C/tH_̃pX̂O
		/// </summary>
		abstract public string Name { get;}

		/// <summary>
		/// t@C/tH_̃pX܂񂾖O
		/// </summary>
		abstract public string FullName { get;}

		/// <summary>
		/// gqBhbg܂
		/// </summary>
		abstract public string Extension { get;}


		/// <summary>
		/// TCY\i1024ȏKBƕ\L铙AȃTCYł͂Ȃj
		/// </summary>
		abstract public string SizeDisplayString { get;}

		/// <summary>
		/// XV
		/// </summary>
		abstract public string UpdateDateString { get;}

		/// <summary>
		/// t@C/tH_݂邩ǂ
		/// </summary>
		abstract public bool Exists { get;}

		/// <summary>
		/// ACẽTlCC[W擾iTCY̓IvVŐݒ肵lj
		/// </summary>
		abstract public Image ThumnailImage { get;}

		abstract public Icon Icon { get;}

		/// <summary>
		/// t@C/tH_̏XV
		/// CX^X𐶐Ă玞ԂꍇÃ\bhĂ΂ȂƁAʂ̃vZXɂA擾Ƃ񂪕ςĂ\
		/// </summary>
		abstract public void Refresh();

		/// <summary>
		/// fullNamet@C/tH_ǂ炩𔻒fāAFileFolderNX𐶐
		/// </summary>
		/// <param name="fullName">t@CtH_̃tpX</param>
		/// <returns>CX^XBfullNamẽt@C/tH_݂Ȃnull</returns>
		static public IFilerItem CreateItem(string fullName) {
			if (System.IO.Directory.Exists(fullName)) {
				return new Folder(fullName);
			} else if (System.IO.File.Exists(fullName)) {
				return new File(fullName);
			} else {
				return null;
			}
		}

		/// <summary>
		/// File^̃XgAt@CpX̔zɕϊĕԂ
		/// </summary>
		/// <param name="itemList">File^̃Xg</param>
		/// <returns>string[]ɕϊz</returns>
		public static string[] GetStringArrayFromFileList(List<IFilerItem> itemList) {
			string[] fileNames = new string[itemList.Count];
			for (int i = 0; i < itemList.Count; i++) {
				fileNames[i] = itemList[i].FullName;
			}
			return fileNames;
		}

		/// <summary>
		/// t@CpX̔z񂩂AFileNX̃Xg𐶐
		/// </summary>
		/// <param name="files">t@C̃tpX̔z</param>
		/// <returns>̔zFile^ɕϊXg</returns>
		public static List<IFilerItem> GetFileListFromStringArray(string[] files) {
			List<IFilerItem> list = new List<IFilerItem>();
			for (int i = 0; i < files.Length; i++) {
				list.Add(FilerItem.CreateItem(files[i]));
			}
			return list;
		}
	}
}
