using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.ItemInterface;

namespace SCFiler2.CommonDialog {
	public partial class FilerItemSelectDialog : Form {
		public FilerItemSelectDialog() {
			InitializeComponent();
		}

		public string DialogTitle {
			set { this.Text = value; }
		}

		public void setItems(List<IFilerItem> itemList) {
			this.FilerItemListView.Items.Clear();
			ColumnHeader header = new ColumnHeader();
			header.Width = this.FilerItemListView.Width-5;
			this.FilerItemListView.Columns.Add(header);

			foreach (IFilerItem item in itemList) {
				ListViewItem viewItem = new ListViewItem();
				viewItem.Text = item.Name;
				viewItem.Tag = item;
				FilerItemListView.Items.Add(viewItem);
			}
			if (FilerItemListView.Items.Count > 0) {
				FilerItemListView.Items[0].Selected = true;
			}
		}

		public IFilerItem SelectedItem {
			get {
				if (FilerItemListView.SelectedItems.Count == 0) {
					return null;
				} else {
					//ACeΉ
					return (IFilerItem)FilerItemListView.SelectedItems[0].Tag;
				}
			}
		}

		private void FilerItemListView_SelectedIndexChanged(object sender, EventArgs e) {
			if (this.FilerItemListView.FocusedItem != null) {
				this.TestLabel.Text = ((IFilerItem)this.FilerItemListView.FocusedItem.Tag).FullName;
			}
		}

		private void okButton_Click(object sender, EventArgs e) {
			if (this.FilerItemListView.SelectedItems.Count == 0) {
				this.DialogResult = DialogResult.Cancel;
			} else {
				this.DialogResult = DialogResult.OK;
			}
			this.Close();
		}
	}
}