using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using SCFiler2.Util;

namespace SCFiler2 {
	public class Images {
		static public Icon Folder = SCFiler2.Properties.Resources.folderIcon;
        static public Icon Default = SCFiler2.Properties.Resources.defaultIcon;
		static public Icon Hdd = SCFiler2.Properties.Resources.HddIcon;
		static public Icon CDROM = SCFiler2.Properties.Resources.CdromIcon;
		static public Icon RemovableDrive = SCFiler2.Properties.Resources.RemovableDiskIcon;
		static public Icon NetworkDrive = SCFiler2.Properties.Resources.NetworkDiskIcon;

		static public Image FolderThumbnail = null;
		static public Image DefaultThumbnail = null;

		private Images() {
		}

		static Images() {
			ThumnailSizeReCalc();
		}

		static public void ThumnailSizeReCalc() {
			FolderThumbnail = ImageUtil.GetSizeTransformedImage(
				SCFiler2.Properties.Resources.folderIcon.ToBitmap(),
				SCFiler2System.Instance.Option.FileView.ThumbnailWidth,
				SCFiler2System.Instance.Option.FileView.ThumbnailHeight,
				false);
			DefaultThumbnail = ImageUtil.GetSizeTransformedImage(
				SCFiler2.Properties.Resources.defaultIcon.ToBitmap(),
				SCFiler2System.Instance.Option.FileView.ThumbnailWidth,
				SCFiler2System.Instance.Option.FileView.ThumbnailHeight,
				false);
		}
	}
}
