using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.Util;
using SCFiler2.Operation;

namespace SCFiler2.ListViewControl {
	public class IncrementalSearchItemSearcher : ItemSearcher{

		private string searchString;//Ώۂ̕

		///̃T[`ŌACe/Ȃnull
		private VirtualListViewItem foundItem;

		/// <summary>
		/// CN^T[`̌ʌListViewItemBȂnull͂Ă
		/// </summary>
		public override VirtualListViewItem FoundItem {
			get { return this.foundItem; }
		}

		public IncrementalSearchItemSearcher(ListViewController parentController, VirtualListView targetView) 
			: base(parentController, targetView) {
		}

		public override ItemSearcher.SearchType Type {
			get { return SearchType.Incremental; }
		}

		public override void Initialize() {
			searchString = "";
			SCFiler2System.ShowTempMessage("Incremental Search: (Enter Search String)");
		}

		public override void Terminate() {
			SCFiler2System.ShowTempMessage("Incremental Search Mode End");
		}

		/// <summary>
		/// L[̏
		/// </summary>
		/// <param name="keyEvent">ꂽL[</param>
		/// <returns>L[</returns>
		override public Result KeyDown(KeyEventArgs keyEvent) {
			//1.EscapeL[ꂽƂCN^T[`I
			//2.BackSpaceL[ꂽƂPčČ
			//3.At@xbgL[ꂽƂɃAt@xbgǉčČ
			//4.CN^T[`̃L[R}hē͂̂ƂŎ
			//5.LȊÕNXł͏Ȃ

			if (keyEvent.KeyCode == Keys.Escape) {
				Terminate();
				return Result.ExitCurrentSearchMode;
			} else if (keyEvent.KeyCode == Keys.Back) {
				try {
					searchString = searchString.Remove(searchString.Length - 1);
					Search(true);
				} catch (ArgumentException) {
					foundItem = null;
					return Result.ItemNotFound; //""̏ԂBackSpaceĂȂBA͒lƂĂ͗LȂ̂trueԂ
				}
			} else if (StringUtil.IsAlphabet(keyEvent.KeyCode) && !keyEvent.Control && !keyEvent.Alt && !keyEvent.Shift) {
				AddSearchChar(keyEvent.KeyCode.ToString());
				Search(true);
			} else if (KeyCommandManager.Instance.GetAssignedKeyCommand(ActionManager.ActionID.IncrementalSearch)
				==KeyCommandManager.Instance.GetCommandString(keyEvent.Control,keyEvent.Alt,keyEvent.Shift,keyEvent.KeyCode)){
				//̒ǉȂāACN^T[`R}hē͂ŁA̃ACe
				Search(false);
			} else {
				return Result.NotHandled;
			}

			//sꂽƂ
			if (foundItem != null) {
				return Result.ItemFound;
			} else {
				return Result.ItemNotFound;
			}
		}

		/// <summary>
		/// CN^T[`̕ǉ
		/// </summary>
		/// <param name="s">ǉ镶</param>
		private void AddSearchChar(string stringToBeAdded) {
			//TODO L͕񒷂PƂŎBƂłƎ悢
			searchString += stringToBeAdded.ToLower(); //ɓꂵĔr
		}

		/// <summary>
		/// ACě
		/// </summary>
		/// <param name="IsStartFromSelectedItem">ݑI𒆂̃ACen߂邩ǂBfalsȅꍇ͑IACe̎</param>
		/// <returns>VIACeBȂꍇnull</returns>
		private void Search(bool IsStartFromSelectedItem) {
			int startIndex = 0;
			string printString = "Incremental Search: " + searchString; //Xe[^Xo[ɕ\镶

			//ǂn߂邩߂
			if (targetView.SelectedItems.Count > 0) {
				if (IsStartFromSelectedItem == true) {
					startIndex = targetView.SelectedItems[0].Index;
				} else {
					if (targetView.SelectedItems[0].Index >= targetView.Items.Count - 1) { //Ō̃ACe
						startIndex = 0;
					} else {
						startIndex = targetView.SelectedItems[0].Index + 1;
					}
				}
			}

			//
			int index = startIndex;
			while (true) {
				FilerItem item = (FilerItem)targetView.Items[index].Tag;
				string name = item.NameWithoutExtension.ToLower();
				string extension = item.Extension.ToLower();
				if (name.IndexOf(searchString) >= 0 || extension.IndexOf(searchString) >= 0) {
					//SĂ̑I
					foreach (VirtualListViewItem oldSelectedItem in targetView.SelectedItems) {
						oldSelectedItem.Selected = false;
					}
					//ACeI
					foundItem = targetView.Items[index];
					break;
				}

				index++;
				//ԉ܂ŗɖ߂
				if (index == targetView.Items.Count) {
					index = 0;
				}

				//猩ȂƂ
				if (index == startIndex) {
					printString += " (Not Found)";
					foundItem = null;
					break;
				}
			}
			SCFiler2System.ShowTempMessage(printString);
		}

	}
}
