using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2.CommonDialog {
	public partial class IsDeleteDialog : Form {
        new public enum DialogResult {
            Yes,
            No,
            AllYes,
            AllNo,
        }

        private DialogResult result;
        private FilerItem target = null;

		/// <summary>
		/// _CAO{ɕ\镶
		/// </summary>
		public string Message {
			set { this.MessageLabel.Text = value; }
		}

        public IsDeleteDialog(FilerItem target){
            this.target = target;
            this.result = DialogResult.No;
            InitializeComponent();
            InitializeDisplay();
        }

		new public DialogResult ShowDialog() {
			base.ShowDialog();
			return this.result;
		}

        private void InitializeDisplay() {
			this.MessageLabel.Text = target.Name + " ͓ǂݎpł폜Ă悢łH";
            this.TargetFileSizeLabel.Text = this.target.SizeDisplayString;
            this.TargetFileUpdateDateLabel.Text = this.target.UpdateDateString;
            this.TargetFileFullNameLabel.Text = this.target.FullName;
        }

		private void IsOverrideDialog_Load(object sender, EventArgs e) {

		}

        private void YesButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.Yes;
			Close();
        }

        private void NoButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.No;
			Close();
        }

        private void AllYesButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.AllYes;
			Close();
        }

        private void AllNoButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.AllNo;
			Close();
		}

		private void YesButton_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) {
				this.result = DialogResult.Yes;
				Close();
			}
		}

		private void NoButton_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) {
				this.result = DialogResult.No;
				Close();
			}
		}

		private void AllYesButton_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) {
				this.result = DialogResult.AllYes;
				Close();
			}
		}

		private void AllNoButton_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) {
				this.result = DialogResult.AllNo;
				Close();
			}
		}


	}
}