using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;

namespace SCFiler2.CommonDialog {
	public partial class IsOverwriteDialog : Form {
        new public enum DialogResult {
            Yes,
            No,
            AllYes,
            AllNo,
        }

        private DialogResult result;
        private IFilerItem source = null;
        private IFilerItem target = null;

        //public IsOverwriteDialog() {
        //    InitializeComponent();
        //}

        public IsOverwriteDialog(IFilerItem target, IFilerItem source){
            this.target = target;
            this.source = source;
            this.result = DialogResult.No;
            InitializeComponent();
            InitializeDisplay();
        }

        private void InitializeDisplay() {
			this.MessageLabel.Text = source.Name + "݂͑܂B";

			if (this.target.Type == ItemType.File) {
				this.TargetFileSizeLabel.Text = this.target.SizeDisplayString;
			} else {
				this.TargetFileSizeLabel.Text = "";
			}

            this.TargetFileUpdateDateLabel.Text = this.target.UpdateDateString;
			this.TargetFileFullNameLabel.Text = this.target.FullName;

			if (this.source.Type == ItemType.File) {
				this.SourceFileSizeLabel.Text = this.source.SizeDisplayString;
			} else {
				this.SourceFileSizeLabel.Text = "";
			}
            this.SourceFileUpdateDateLabel.Text = this.source.UpdateDateString;
            this.SourceFileFullNameLabel.Text = this.source.FullName;
        }

		new public DialogResult ShowDialog() {
			base.ShowDialog();
			return this.result;
		}

		private void IsOverrideDialog_Load(object sender, EventArgs e) {

		}

        private void YesButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.Yes;
			this.Close();
        }

        private void NoButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.No;
			this.Close();
        }

        private void AllYesButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.AllYes;
			this.Close();
        }

        private void AllNoButton_Click(object sender, EventArgs e) {
            this.result = DialogResult.AllNo;
			this.Close();
        }

		private void IsOverwriteDialog_KeyDown(object sender, KeyEventArgs e) {
			switch (e.KeyCode) {
				case Keys.A:
					this.result = DialogResult.AllYes;
					break;
				case Keys.C:
					this.result = DialogResult.AllNo;
					break;
				case Keys.Y:
					this.result = DialogResult.Yes;
					break;
				case Keys.N:
					this.result = DialogResult.No;
					break;
			}
			this.Close();
		}
	}
}