using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// ListViewɂt@C̃tH[JXړ̎i񋟂
	/// KeyDownCxgɉɃtH[JX𓖂ĂׂACeT
	/// ۂɃtH[JX𓖂ĂAI͂̃NXł͍sȂ
	/// </summary>
	abstract public class ItemSearcher {
		/// <summary>
		/// ItemSearcherĂController
		/// </summary>
		protected ListViewController parentController;
		/// <summary>
		/// ItemSearcherΏۂListVIew
		/// </summary>
		protected VirtualListView targetView;

		public ItemSearcher(ListViewController parentController, VirtualListView targetView) {
			Debug.Assert(targetView != null, "targetView==null");
			Debug.Assert(parentController != null, "parentController==null");
			this.parentController = parentController;
			this.targetView = targetView;
		}

		public enum SearchType {
			/// <summary>
			/// ł{IȃT[`B\L[̏㉺APageUp/Down
			/// </summary>
			Basic,
			/// <summary>
			/// pL[ł̓T[`
			/// </summary>
			Prefix,
			/// <summary>
			/// pł̃CN^T[`
			/// </summary>
			Incremental,
			/// <summary>
			/// MigemoT[`
			/// </summary>
			Migemo,
		}

		/// <summary>
		/// ItemSearcher̃CX^X̃^Cv
		/// </summary>
		abstract public SearchType Type { get; }

		public enum Result {
			/// <summary>
			/// ItemSearcherŏȂƂ
			/// </summary>
			NotHandled,
			/// <summary>
			/// ACeȂƂ
			/// </summary>
			ItemNotFound,
			/// <summary>
			/// Ƃ/܂łƓACew܂
			/// </summary>
			ItemFound,
			/// <summary>
			/// ̌@IƂR}h͂ꂽƂ
			/// </summary>
			ExitCurrentSearchMode,
		}

		/// <summary>
		/// KeyDownɌACe/Ȃnull
		/// </summary>
		abstract public VirtualListViewItem FoundItem { get;}

		/// <summary>
		/// L[Cxg郁\bh
		/// </summary>
		/// <param name="KeyEvent">L[Cxg</param>
		/// <returns></returns>
		abstract public Result KeyDown(KeyEventArgs KeyEvent);

		/// <summary>
		/// ItemSearcheȑ
		/// </summary>
		abstract public void Initialize();

		/// <summary>
		/// ItemSearcherI鎞ɕKvȏ
		/// </summary>
		abstract public void Terminate();

	}
}
