using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// SCFilerł̂P܂Ƃ܂̎diRs[A폜AړȂǁj̒P
	/// iɑ΂Action̓[U[̑̒Pʁj
	/// yTuNX̎@z
	/// ERXgN^ŏΏۂ̃t@CȂǂ擾Ă
	/// EProcess()\bhɎۂ̏eLqĂ
	/// ELZ͊{IProcess()IsCancelRequired`FbN悤ɎBKvłCancel()\bhoverrideB
	/// </summary>
	public abstract class Job {
		private Thread jobThread;

		public void ThreadJoin() {
			if (jobThread == null) {
				return;
			}
			jobThread.Join();
		}

		/// <summary>
		/// Wusɏ󋵂_CAO\邩ǂ
		/// </summary>
		private bool isShowDialog = false;

		/// <summary>
		/// isShowDialogtrueɂȂƂɕ\_CAÕ^Cg
		/// </summary>
		private string dialogTitle;

		/// <summary>
		/// ɕ\_CAOi\邩ǂ̓JX^}CY\j
		/// </summary>
		private OperationProcessDialog dialog;

		/// <summary>
		/// [U[LZ̗vǂ
		/// </summary>
		private bool isCancelRequired = false;

		/// <summary>
		/// IꂽƂ̒ʒm̂߂̃fQ[g
		/// </summary>
		public EventHandler Finish = null;

		/// <summary>
		/// WuIƂ
		/// </summary>
		public void JobFinished() {
			this.dialog = null;
			if (Finish != null) {
				Finish(this, null);
			}
			jobThread = null;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="dialogTitle">_CAO\ꍇ̃^CgBTuNXijɂČ܂</param>
		public Job(string dialogTitle) {
			this.dialogTitle = dialogTitle;
		}

		/// <summary>
		/// [U[LZvꂽǂBtrue珈LZďI
		/// </summary>
		protected bool IsCancelRequired {
			get {
				lock (this) {
					return this.isCancelRequired;
				}
			}
		}

		/// <summary>
		/// Xe[^Xo[܂̓_CAOɏ󋵂\Bɏ̃t@C\邱Ƃz肵Ă
		/// </summary>
		/// <param name="message">\郁bZ[W</param>
		protected void ShowProcessMessage(string message) {
			if (isShowDialog) {
				dialog.SetMessage(message);
			} else {
				SCFiler2System.ShowTempMessage(message);
			}
		}

		/// <summary>
		/// TuNXŎۂ̃WȕLqBExecute()ɂʃXbhƂČĂяo
		/// LZoverrideꍇȊÓAIsCancelRequired`FbNāA𒆒fł悤ɂĂ
		/// ꎞIȏ󋵂ShowProcessMessage()Ăяoĕ\BiOƂĎcꍇȂǂ͕ʃ\bhgj
		/// </summary>
		abstract protected void Process();

		private void StartProcess() {
			this.Process();
			this.JobFinished();
		}

		/// <summary>
		/// LZB
		/// Process[vĂꍇ́Ã\bh͏ItO𗧂Ă邾ŁAProcess()̕ŃtOĂI悤ɂĂB
		/// </summary>
		public virtual void Cancel() {
			lock (this) {
				this.isCancelRequired = true;
			}
		}

		/// <summary>
		/// sBOĂтꂽƂɁAʃXbhStart()Ăяo
		/// </summary>
		public void Execute() {
			//ɂق̏\ł΁AʃXbhŋN
			//Ȃ΁A_CAOoď󋵂\Ȃ珈

			if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
				this.isShowDialog = false;
				jobThread = new Thread(new ThreadStart(this.StartProcess));
				jobThread.Start();
			} else {
				this.isShowDialog = true;
				this.dialog = new OperationProcessDialog();
				this.dialog.Top = MainForm.Instance.Top + 50;
				this.dialog.Left = MainForm.Instance.Left + 50;
				this.dialog.Text = this.dialogTitle;
				jobThread = this.dialog.ShowDialogAndStartProcess(this.StartProcess, this.Cancel);
			}

			
		}
	}
}
