using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;

namespace SCFiler2.CommonDialog {
	public partial class JumpFolderDialog : Form {
		private IJumpFolder selectedJumpfolder;
		private JumpFolderManager manager;

		public JumpFolderDialog() {
			InitializeComponent();
		}

		/// <summary>
		/// IꂽJumpFolderBLZꂽƂnullĂB
		/// </summary>
		public IJumpFolder SelectedJumpFolder {
			get { return selectedJumpfolder; }
		}

		private void JumpFolderForm_Load(object sender, EventArgs e) {
			manager = JumpFolderManager.Instance;
			UpdateJumpFolderList();
		}

		/// <summary>
		/// WvtH_̃Xg`悷
		/// </summary>
		private void UpdateJumpFolderList() {
			listView.Items.Clear();
			List<IJumpFolder> list = JumpFolderManager.Instance.JumpFolders;
			for (int i = 0; i < list.Count; i++) {
				ListViewItem item = new ListViewItem(list[i].Folder.Name);
				item.Tag = list[i];
				listView.Items.Add(item);
			}
			//֗Ȃ悤ɍŏ̃ACeɃtH[JX𓖂ĂĂ
			if (listView.Items.Count > 0) {
				listView.Items[0].Focused = true;
				listView.Items[0].Selected = true;
			}
		}

		private void okButton_Click(object sender, EventArgs e) {
			this.DialogResult = DialogResult.OK;
			if (listView.SelectedItems.Count > 0) {
				ListViewItem item = listView.SelectedItems[0];
				selectedJumpfolder = (IJumpFolder)item.Tag;
			} else {
				selectedJumpfolder = null;
			}
			Close();
		}

		private void cancelButton_Click(object sender, EventArgs e) {
			this.DialogResult = DialogResult.Cancel;
			selectedJumpfolder = null;
			Close();
		}

		private void itemUpButton_Click(object sender, EventArgs e) {
			manager.ItemOrderUp((JumpFolder)listView.SelectedItems[0].Tag);
			UpdateJumpFolderList();
		}

		private void itemDownButton_Click(object sender, EventArgs e) {
			manager.ItemOrderDown((JumpFolder)listView.SelectedItems[0].Tag);
			UpdateJumpFolderList();
		}

		private void listView_SelectedIndexChanged(object sender, EventArgs e) {
			if (this.listView.SelectedItems.Count > 0) {
				this.FilePathLabel.Text = ((JumpFolder)this.listView.SelectedItems [0].Tag).Folder.FullName;
			}
		}

		private void delButton_Click(object sender, EventArgs e) {
			JumpFolderManager.Instance.RemoveFolder((IJumpFolder)this.listView.SelectedItems[0].Tag);
			this.UpdateJumpFolderList();
			this.listView.Focus();
		}
	}
}