﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.ListViewControl;

namespace SCFiler2.Util {
	public class ListViewUtil {
		static public void SetFocusAndSelectFirstItem(VirtualListView targetListView) {
			if (targetListView.Items.Count == 0) {
				return;
			}
			targetListView.Items[0].Focused = true;
			targetListView.SelectedItems.Clear();
			targetListView.Items[0].Selected = true;
			targetListView.Items[0].EnsureVisible();
			targetListView.Update();
		}

		/// <summary>
		/// 表示領域の一番上のアイテムを取得する
		/// </summary>
		/// <param name="targetListView"></param>
		/// <returns></returns>
		static public VirtualListViewItem GetTopItemInClientArea(VirtualListView targetListView) {
			return targetListView.TopItem;
		}

		/// <summary>
		/// 表示領域の一番下のアイテムを取得する。半分で切れている場合などはそのうえのアイテムを返す
		/// </summary>
		/// <param name="targetListView"></param>
		/// <returns>該当するアイテム。アイテムが一つもない時にはnullが返る</returns>
		static public VirtualListViewItem GetBottomItemInClientArea(VirtualListView targetListView) {
			if (targetListView.Items.Count == 0) {
				return null;
			}
			VirtualListViewItem bottomItem = targetListView.GetItemAt(0, targetListView.ClientSize.Height - 1);
			if (bottomItem == null) {
				bottomItem = targetListView.Items[targetListView.Items.Count - 1];
			} else if (bottomItem.Index > 1) {
				//そのまま返すと境界の（表示が切れている）アイテムが返るので、その１個上のアイテムを返す
				bottomItem = targetListView.Items[bottomItem.Index - 1];
			}
			return bottomItem;
		}

		/// <summary>
		/// １画面分PageUpして、画面上一番上のアイテムを返す。スクロールは必ずする。フォーカス/セレクト状態は変更しない
		/// </summary>
		/// <param name="targetListView">操作対象のリストビュー</param>
		/// <returns>スクロールした先のTopItem</returns>
		static public VirtualListViewItem GetTopItemWhenOnePageUp(VirtualListView targetListView) {
			VirtualListViewItem oldTop = targetListView.TopItem;
			int index = oldTop.Index;
			while (true) {
				if (index == 0) {
					return targetListView.Items[0];
				} else if (targetListView.GetItemAt(0, targetListView.ClientSize.Height - 1) == oldTop) {
					return targetListView.Items[index];
				}
				index--;
				targetListView.TopItem = targetListView.Items[index];
			}
		}

		/// <summary>
		/// １画面分PageDownして、画面上一番上のアイテムを返す。スクロールは必ずする。フォーカス/セレクト状態は変更しない
		/// </summary>
		/// <param name="targetListView">操作対象のリストビュー</param>
		/// <returns>スクロールした先のBottom</returns>
		static public VirtualListViewItem GetBottomItemWhenOnePageDown(VirtualListView targetListView) {
			VirtualListViewItem oldBottom = GetBottomItemInClientArea(targetListView);
			int index = targetListView.TopItem.Index;

			//実行前の最下段のアイテムが一番上にくるか、画面の一番下にリストビューの最後のアイテムが来るまでページを送る
			while (targetListView.TopItem != oldBottom && 
				GetBottomItemInClientArea(targetListView).Index < targetListView.Items.Count -1) {
				index++;
				targetListView.TopItem = targetListView.Items[index];

				//GetBottomItemInClientArea()の作りの関係上
				//画面領域下がアイテムが切れないサイズになっている時、無限ループに入ってしまう
				//その暫定対策↓
				if (index == targetListView.Items.Count - 1) {
					return targetListView.Items[index];
				}
			}
			return GetBottomItemInClientArea(targetListView);
		}
	}
}
