using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	class MoveToDriveCatalogue : Action {
		public override string DisplayString {
			get { return "hCuꗗɈړ"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView view = ViewInterfaces.LastFocusedFileView;
			view.ChangePath("");
			view.SelectMode = SelectMode.Normal;
		}
	}
}
