using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class MoveToParentFolder : Action {
		public override string DisplayString {
			get { return "etH_Ɉړ"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				if (view.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}else if (view.CurrentPath.Length == 3) {
					//hCu[gꍇ́AhCuꗗɈړ
					view.ChangePath("");
					view.SelectMode = SelectMode.Normal;
				} else {
					try {
						System.IO.DirectoryInfo parent = System.IO.Directory.GetParent(view.CurrentPath);//etH_擾
						view.ChangePath(parent.FullName, view.CurrentPath);
						view.SelectMode = SelectMode.Normal;
					} catch (NullReferenceException) {
						SCFiler2System.ShowTempMessage("ړ悤Ƃ悪܂");
					}
				}
			} else {
				//ȊÕr[ɃtH[JXƂ͉Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
