using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCFiler2.CommonDialog {
	public partial class OperationTargetDialog : Form {
		public enum Target {
			AnotherView,
			Clipboard,
			JumpFolder,
			RightUnder,
		}

		private Target selectedTarget = Target.AnotherView;
		public Target SelectedTarget {
			get { return selectedTarget; }
			set { selectedTarget = value; }
		}

		public string DialogTitle {
			set { this.Text = value; }
			get { return this.Text; }
		}

		public OperationTargetDialog() {
			InitializeComponent();
		}

		private void okButton_Click(object sender, EventArgs e) {
			if (anotherViewRadioButton.Checked) {
				this.selectedTarget = Target.AnotherView;
			} else if (ClipboardRadioButton.Checked) {
				this.selectedTarget = Target.Clipboard;
			} else if (JumpFolderRadioButton.Checked) {
				this.selectedTarget = Target.JumpFolder;
			} else if (RightUnderRadioButton.Checked) {
				this.selectedTarget = Target.RightUnder;
			}
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void OperationTargetDialog_KeyDown(object sender, KeyEventArgs e) {

		}

	}
}