using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.PluginInterface;

namespace SCFiler2.Plugin {
	public class PluginManager {
		static public PluginManager Instance = new PluginManager();

		private PluginManager() {
		}

		private List<Client> plugins = new List<Client>();

		public List<Client> Plugins {
			get { return plugins; }
		}

		/// <summary>
		/// vOCۑtH_
		/// </summary>
		private string pluginFolder = System.Windows.Forms.Application.StartupPath + @"\Plugins";

		private string pluginInterfaceName = typeof(Client).FullName;

		public void LoadAllPlugins() {
			//vOCtH_ȂΌɏI
			if (!System.IO.Directory.Exists(pluginFolder)) {
				return;
			}

			string[] dllFiles = System.IO.Directory.GetFiles(pluginFolder, "*.dll");

			foreach (string dllFile in dllFiles) {
				try {
					System.Reflection.Assembly assembly = System.Reflection.Assembly.LoadFrom(dllFile);
					foreach (Type type in assembly.GetTypes()) {
						if (type.IsClass && type.IsPublic && !type.IsAbstract && type.IsSubclassOf(typeof(Client))) {
							Client plugin = (Client)assembly.CreateInstance(type.FullName);
							plugins.Add(plugin);
							plugin.ActionOnApplicationLoad();
						}
					}
				} catch (Exception e) {
					SCFiler2System.ShowHistoryMessage("[error]" + e.Message);
				}
			}
		}

		public void NoticeAppClosingToAllPlugin() {
			foreach (Client plugin in this.plugins) {
				plugin.ActionOnApplicationClose();
			}
		}
	}
}
