using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Util;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// ŃACeItemSearcher
	/// </summary>
	public class PrefixItemSearcher : ItemSearcher {
		private VirtualListViewItem foundItem;

		public PrefixItemSearcher(ListViewController parentController, VirtualListView targetView) 
			: base(parentController, targetView) {
			System.Diagnostics.Debug.Assert(targetView != null, "targetView==null");
		}

		public override ItemSearcher.SearchType Type {
			get { return SearchType.Prefix; }
		}

		public override VirtualListViewItem FoundItem {
			get { return this.foundItem; }
		}

		public override void Initialize() {
		}

		public override void Terminate() {
			//ɕKvȂ
		}

		public override Result KeyDown(KeyEventArgs keyEvent) {
			if (keyEvent.Alt || keyEvent.Control || keyEvent.Shift) {
				return Result.NotHandled;
			} else if (targetView.Items.Count == 0) {
				return Result.ItemFound;
			} else if (StringUtil.IsAlphabet(keyEvent.KeyCode)) {
				return Search(keyEvent);
			} else {
				return Result.NotHandled;
			}
		}

		private Result Search(KeyEventArgs keyEvent) {
			if (this.targetView.Items.Count == 0) {
				return Result.ItemNotFound;
			}

			//At@xbgꂽƂ́A̕Ŏn܂ACeɃtH[JXړ

			int startIndex = 0;

			//݂̃tH[JXłɂ̕Ŏn܂ĂẢ̃ACeJn

			if ((targetView.FocusedItem != null && targetView.FocusedItem.Text.Length > 0)
					&& char.ToLower(targetView.FocusedItem.Text[0]) == char.ToLower(keyEvent.KeyCode.ToString()[0])) {
				startIndex = targetView.FocusedItem.Index + 1;
				if (startIndex == targetView.Items.Count) {
					startIndex = 0;
				}
			} else {
				if (targetView.FocusedItem != null) {
					startIndex = targetView.FocusedItem.Index;
				}
			}

			//
			int index = startIndex;
			while (true) {
				if (targetView.Items[index].Text.Length > 0 && char.ToLower(targetView.Items[index].Text[0]) == char.ToLower(keyEvent.KeyCode.ToString()[0])) {
					foundItem = targetView.Items[index];
					return Result.ItemFound;
				}

				index++;
				//ԉɓBԏɖ߂
				if (index == targetView.Items.Count) {
					index = 0;
				}
				//I
				if (index == startIndex) {
					foundItem = null;
					return Result.ItemNotFound;
				}
			}
		}

	}
}
