using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	class PreviewMode : Action{
		public override string DisplayString {
			get { return "vr["; }
		}

		public override ActionType Type {
			get { return ActionType.View; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView focusedView = ViewInterfaces.LastFocusedFileView;
				IFileView unfocusedView = ViewInterfaces.OtherOfLastFocusedFileView;

				if (unfocusedView.ViewMode != ViewMode.PreviewInPreviewMode) {
					unfocusedView.ViewMode = ViewMode.PreviewInPreviewMode;
				} else {
					//łɃvr[vr[[h𔲂
					unfocusedView.ViewMode = ViewMode.Normal;
				}
			}
		}
	}
}
