using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.Util;
using SCFiler2.CommonDialog;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class Rename : Action {
		public override string DisplayString {
			get { return "O̕ύX"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowDialogMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView view = ViewInterfaces.LastFocusedFileView;
			List<IFilerItem> items = view.SelectedFilerItems;
			if (items.Count == 0) {
				SCFiler2System.ShowTempMessage("t@CIĂ܂");
				return;
			}
			if (items.Count > 1) {
				SCFiler2System.ShowTempMessage("t@CIĂ̂ŖO̕ύXsł܂");
			}
			if (view.CurrentPath == "") { //hCuꗗ̏ꍇ
				Drive drive = (Drive)items[0];
				InputTextForm form = new InputTextForm("O̕ύX", drive.VolumeLabel);
				form.ShowDialog();
				if (form.DialogResult == System.Windows.Forms.DialogResult.Cancel) {
					SCFiler2System.ShowTempMessage("[O̕ύX]̓LZ܂");
					return;
				}
				string oldName = drive.VolumeLabel;
				drive.VolumeLabel = form.GetInputtedText();
				SCFiler2System.ShowHistoryMessage(oldName + "" + drive.VolumeLabel + "ɕύX܂");
				view.UpdateView();
				view.SelectMode = SelectMode.Normal;

			} else { //t@Cꗗ̏ꍇ
				
				//VO̎擾
				//gqāAgqȊOIԂɂ
				IFilerItem item = items[0];
				System.Text.RegularExpressions.Regex regex = new System.Text.RegularExpressions.Regex("\\.\\w+$");
				System.Text.RegularExpressions.Match regexMatch = regex.Match(item.Name);
				InputTextForm form;
				if (regexMatch.Success) {
					form = new InputTextForm("O̕ύX", item.Name, 0, regexMatch.Index - 1);
				} else {
					form = new InputTextForm("O̕ύX", item.Name);
				}
				form.ShowDialog();
				if (form.DialogResult == System.Windows.Forms.DialogResult.Cancel) {
					SCFiler2System.ShowTempMessage("[O̕ύX]̓LZ܂");
					return;
				}
				string oldName = item.Name;
				string newName = form.GetInputtedText();

				//s
				if (item.Type == ItemType.File) {
					if (System.IO.File.Exists(item.Path + @"/" + newName)) {
						SCFiler2System.ShowHistoryMessage(newName + "͊ɑ݂܂̂ŁAO̕ύX͂ł܂");
						return;
					}
					Microsoft.VisualBasic.FileIO.FileSystem.RenameFile(item.FullName, newName);
				} else {
					if (System.IO.Directory.Exists(item.Path + @"/" + newName)) {
						SCFiler2System.ShowHistoryMessage(newName + "͊ɑ݂܂̂ŁAO̕ύX͂ł܂");
						return;
					}
					Microsoft.VisualBasic.FileIO.FileSystem.RenameDirectory(item.FullName, newName);
				}
				SCFiler2System.ShowHistoryMessage(oldName + "  " + newName + "ɕύX܂");
				view.UpdateView();
				view.SelectMode = SelectMode.Normal;
			}
		}
	}
}
