using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.CommonDialog;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// 
	/// </summary>
	class RepeatDeleteReadonlyState {
		enum RepeatSate {
			Normal,
			DeleteEvery,
			NotDeleteEvery,
		}
		RepeatSate state = RepeatSate.Normal;

		/// <summary>
		/// targetFile폜ׂǂ
		/// </summary>
		/// <param name="source"></param>
		/// <returns>폜Ȃtrue/ȂȂfalse</returns>
		public bool IsDelete(FilerItem target) {
			switch (state) {
				case RepeatSate.Normal:
					IsDeleteDialog delDialog = new IsDeleteDialog(target);
					delDialog.TopMost = true;
					IsDeleteDialog.DialogResult result = delDialog.ShowDialog();
					switch (result) {
						case IsDeleteDialog.DialogResult.Yes:
							return true;
						case IsDeleteDialog.DialogResult.No:
							return false;
						case IsDeleteDialog.DialogResult.AllYes:
							this.state = RepeatSate.DeleteEvery;
							return true;
						case IsDeleteDialog.DialogResult.AllNo:
							this.state = RepeatSate.NotDeleteEvery;
							return false;
					}
					break;
				case RepeatSate.DeleteEvery:
					return true;
				case RepeatSate.NotDeleteEvery:
					return false;
			}
			return false;

		}

	}
}
