using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using System.Drawing;
using System.Windows.Forms;

namespace SCFiler2 {
	internal class SCFiler2System {
		//VOg
		static private SCFiler2System instance = new SCFiler2System();

		static internal SCFiler2System Instance {
			get { return instance;}
		}
		private SCFiler2System() {
			Option.Load();
		}

		internal class OptionClass {
			public class KeyCommandOption {
				public bool ChangeDriveByNumKey = false;
				public void Save() {
					OptionUtil.Save("KeyAssign2", this);
				}
				public void Load() {
					OptionUtil.Load("KeyAssign2", this);
				}
			}
			public KeyCommandOption KeyCommand = new KeyCommandOption();

			public class ColorOption {
				public Color ActiveViewTitleBack = new Color();
				public Color ActiveViewTitleText = new Color();
				public Color InactiveViewTitleBack = new Color();
				public Color InactiveViewTitleText = new Color();
				public Color FocusedWithoutSelectedListViewItemText = new Color();
				public Color FocusedWithoutSelectedListViewItemBack = new Color();
				public ColorOption() {
					//l̐ݒ
					ActiveViewTitleBack = System.Drawing.Color.Aqua;
					ActiveViewTitleText = System.Drawing.Color.Black;
					InactiveViewTitleBack = System.Drawing.Color.Azure;
					InactiveViewTitleText = System.Drawing.Color.Black;
					FocusedWithoutSelectedListViewItemBack = System.Drawing.Color.AliceBlue;
					FocusedWithoutSelectedListViewItemText = System.Drawing.Color.Black;
				}
				public void Save() {
					OptionUtil.Save("Color", this);
				}
				public void Load() {
					OptionUtil.Load("Color", this);
				}
			}
			public ColorOption Color = new ColorOption();

			public class FileViewOption {
				public enum FileIconDisp {
					Nothing,
					ExeOnly,
					All
				}
				public List<string> excludeExtensions = new List<string>();
				public bool IsHideHiddenFile = false;
				public bool IsHideSystemFile = true;
				public bool IsDisplayDriveToolbar = true;
				public bool IsDisplayHistoryView = true;
				public FileIconDisp IconDisplay = FileIconDisp.Nothing;
				public int ThumbnailWidth = 120;
				public int ThumbnailHeight = 120;

				public void Save() {
					OptionUtil.Save("FileViewOption", this);
				}
				public void Load() {
					OptionUtil.Load("FileViewOption", this);
				}
			}
			public FileViewOption FileView = new FileViewOption();

			public class HistoryViewOption {
				public int ItemMaxNum = 30;

				public void Save() {
					OptionUtil.Save("HistoryViewOption", this);
				}

				public void Load() {
					OptionUtil.Load("HistoryViewOption", this);
				}
			}
			public HistoryViewOption HistoryView = new HistoryViewOption();

			public class ApplicationOption {
				public bool IsIgnoreFloppyCheck = true;
				public bool IsMinimizeFormWhenAppStart = false;
				public bool IsLoadMigemoWhenAppStart = false;
				public bool IsUseShellContextMenu = false;
				public bool IsAddItemToHistoryWhenDrag;
				public bool IsAllowOperationWhileCopyMoveDel = false;
				public void Save() {
					OptionUtil.Save("ApplicationOption", this);
				}
				public void Load() {
					OptionUtil.Load("ApplicationOption", this);
				}
			}
			public ApplicationOption Application = new ApplicationOption();

			public void Save() {
				KeyCommand.Save();
				Color.Save();
				FileView.Save();
				Application.Save();
				HistoryView.Save();
			}
			public void Load() {
				KeyCommand.Load();
				Color.Load();
				FileView.Load();
				Application.Load();
				HistoryView.Load();
			}
		}
		public OptionClass Option = new OptionClass();

		/// <summary>
		/// bZ[WꎞIɕ\ĩbZ[Wj
		/// </summary>
		/// <param name="text">\</param>
		static public void ShowTempMessage(string text) {
			MainForm.Instance.PrintToStatusbar(text);
		}

		/// <summary>
		/// [UɃ_CAOŃbZ[W\ĊmF𑣂
		/// </summary>
		/// <param name="text">\</param>
		static public void ShowDialogMessage(string text) {
			System.Windows.Forms.MessageBox.Show(text);
		}

		/// <summary>
		/// UI̕\GAɈ̍sX^bNĕ\郁bZ[Wǉ
		/// </summary>
		/// <param name="text">\</param>
		static public void ShowHistoryMessage(string text) {
			MainForm.Instance.PrintToMessageHistoryArea(text);
		}

		static public void ShowDebugMessage(string text) {
			MainForm.Instance.PrintToMessageHistoryArea(text);
		}
	}
}
