using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Operation;
using System.Windows.Forms;
using SCFiler2.CommonDialog;

namespace SCFiler2.Operation {
	public class Sort : Action {
		public override string DisplayString {
			get { return "\[g"; }
		}
		public override ActionType Type {
			get { return ActionType.View; }
		}
		public override void Execute() {
			SortDialog dialog = new SortDialog();
			DialogResult result = dialog.ShowDialog();
			if (result == DialogResult.OK) {
				FileView view = MainForm.Instance.GetLastFocusedFileView();
				view.Sort(dialog.SelectedColumn, SortOrder.Ascending);
			}
		}
	}
}
