using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using SCFiler2.FileSystem;
using System.Windows.Forms;
using SCFiler2.ItemInterface;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// FileViewColumnNbNƂɕёւ邽߂Comparer
	/// </summary>
	public class VirtualListViewComparer : IComparer<VirtualListViewItem> {
		FileView.ColumnType column;
		SortOrder order;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="columnType">ꂽcolumnԖڂ</param>
		public VirtualListViewComparer(int columnNumber) {
			column = (FileView.ColumnType)columnNumber;
			order = SortOrder.Ascending;
		}

		/// <summary>
		/// \[g鎞ɉڂŃ\[g邩w肷
		/// </summary>
		/// <param name="columnType">\[gɎgcolumn̔ԍ</param>
		public void setColumn(int columnNumber) {
			if (column == (FileView.ColumnType)columnNumber) { //NbN܂łƓs甽]
				if (order == SortOrder.Ascending) {
					order = SortOrder.Descending;
				} else {
					order = SortOrder.Ascending;
				}
			} else {
				column = (FileView.ColumnType)columnNumber;
				order = SortOrder.Ascending;
			}
		}

		/// <summary>
		/// ݂̃\[g񂪉ڂԂ
		/// </summary>
		/// <returns>\[gĂcolumn̔ԍiO琔j</returns>
		public int getColumn() {
			return (int)column;
		}

		/// <summary>
		/// \[g~\
		/// </summary>
		public SortOrder Order {
			get { return this.order; }
		}

		#region IComparer<VirtualListViewItem> o

		int IComparer<VirtualListViewItem>.Compare(VirtualListViewItem x, VirtualListViewItem y) {
			FilerItem itemA = x.FilerItem;
			FilerItem itemB = y.FilerItem;
			const int AIsSmaller = -1;
			const int BIsSmaller = 1;

			if (x == y) {
				return 0;
			}

			int returnValue;

			if (itemA.Type != itemB.Type) {
				//tH_ɕ\
				if (itemA.Type == ItemType.Folder) {
					return AIsSmaller;
				} else {
					return BIsSmaller;
				}
			} else {
				if (itemA.Type == ItemType.Folder) {
					switch (column) {
						case FileView.ColumnType.Name:
							returnValue = String.Compare(itemA.Name, itemB.Name);
							break;
						case FileView.ColumnType.Extension:
							returnValue = AIsSmaller;
							break;
						case FileView.ColumnType.Size:
							returnValue = AIsSmaller;
							break;
						case FileView.ColumnType.Date:
							returnValue = DateTime.Compare(((Folder)itemA).UpdateDate, ((Folder)itemB).UpdateDate);
							break;
						default:
							returnValue = AIsSmaller;
							break;
					}
				} else {
					switch (column) {
						case FileView.ColumnType.Name:
							returnValue = String.Compare(itemA.Name, itemB.Name);
							break;
						case FileView.ColumnType.Extension:
							returnValue = String.Compare(itemA.Extension, itemB.Extension);
							break;
						case FileView.ColumnType.Size:
							returnValue = ((File)itemA).Size > ((File)itemB).Size ? BIsSmaller : AIsSmaller;
							break;
						case FileView.ColumnType.Date:
							returnValue = DateTime.Compare(((File)itemA).UpdateDate, ((File)itemB).UpdateDate);
							break;
						default:
							returnValue = AIsSmaller;
							break;
					}
				}
			}
			if (order == SortOrder.Ascending) {
				return returnValue;
			} else {
				return -1 * returnValue;
			}
		}

		#endregion
	}
}
